/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.util.Enumeration;

public class DigestInfo
extends ASN1Object {
    private byte[] a;
    private AlgorithmIdentifier b;

    public static DigestInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DigestInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static DigestInfo getInstance(Object obj) {
        if (obj instanceof DigestInfo) {
            return (DigestInfo)obj;
        }
        if (obj != null) {
            return new DigestInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public DigestInfo(AlgorithmIdentifier algId, byte[] digest) {
        this.a = Arrays.clone(digest);
        this.b = algId;
    }

    public DigestInfo(ASN1Sequence obj) {
        Enumeration enumeration = obj.getObjects();
        this.b = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        this.a = ASN1OctetString.getInstance(enumeration.nextElement()).getOctets();
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.b;
    }

    public byte[] getDigest() {
        return Arrays.clone(this.a);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(new DEROctetString(this.a));
        return new DERSequence(aSN1EncodableVector);
    }
}

