/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import com.enterprisedt.bouncycastle.util.Strings;

public class GeneralNames
extends ASN1Object {
    private final GeneralName[] a;

    public static GeneralNames getInstance(Object obj) {
        if (obj instanceof GeneralNames) {
            return (GeneralNames)obj;
        }
        if (obj != null) {
            return new GeneralNames(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static GeneralNames getInstance(ASN1TaggedObject obj, boolean explicit) {
        return GeneralNames.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static GeneralNames fromExtensions(Extensions extensions, ASN1ObjectIdentifier extOID) {
        return GeneralNames.getInstance(extensions.getExtensionParsedValue(extOID));
    }

    public GeneralNames(GeneralName name) {
        this.a = new GeneralName[]{name};
    }

    public GeneralNames(GeneralName[] names) {
        this.a = names;
    }

    private GeneralNames(ASN1Sequence seq) {
        this.a = new GeneralName[seq.size()];
        for (int i2 = 0; i2 != seq.size(); ++i2) {
            this.a[i2] = GeneralName.getInstance(seq.getObjectAt(i2));
        }
    }

    public GeneralName[] getNames() {
        GeneralName[] generalNameArray = new GeneralName[this.a.length];
        System.arraycopy(this.a, 0, generalNameArray, 0, this.a.length);
        return generalNameArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.a);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("GeneralNames:");
        stringBuffer.append(string);
        for (int i2 = 0; i2 != this.a.length; ++i2) {
            stringBuffer.append("    ");
            stringBuffer.append(this.a[i2]);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

