/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralNames;
import com.enterprisedt.bouncycastle.asn1.x509.IssuerSerial;
import com.enterprisedt.bouncycastle.asn1.x509.ObjectDigestInfo;

public class Holder
extends ASN1Object {
    public static final int V1_CERTIFICATE_HOLDER = 0;
    public static final int V2_CERTIFICATE_HOLDER = 1;
    IssuerSerial a;
    GeneralNames b;
    ObjectDigestInfo c;
    private int d = 1;

    public static Holder getInstance(Object obj) {
        if (obj instanceof Holder) {
            return (Holder)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            return new Holder(ASN1TaggedObject.getInstance(obj));
        }
        if (obj != null) {
            return new Holder(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private Holder(ASN1TaggedObject tagObj) {
        switch (tagObj.getTagNo()) {
            case 0: {
                this.a = IssuerSerial.getInstance(tagObj, true);
                break;
            }
            case 1: {
                this.b = GeneralNames.getInstance(tagObj, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag in Holder");
            }
        }
        this.d = 0;
    }

    private Holder(ASN1Sequence seq) {
        if (seq.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        block5: for (int i2 = 0; i2 != seq.size(); ++i2) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(seq.getObjectAt(i2));
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.a = IssuerSerial.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
                case 1: {
                    this.b = GeneralNames.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
                case 2: {
                    this.c = ObjectDigestInfo.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag in Holder");
                }
            }
        }
        this.d = 1;
    }

    public Holder(IssuerSerial baseCertificateID) {
        this(baseCertificateID, 1);
    }

    public Holder(IssuerSerial baseCertificateID, int version) {
        this.a = baseCertificateID;
        this.d = version;
    }

    public int getVersion() {
        return this.d;
    }

    public Holder(GeneralNames entityName) {
        this(entityName, 1);
    }

    public Holder(GeneralNames entityName, int version) {
        this.b = entityName;
        this.d = version;
    }

    public Holder(ObjectDigestInfo objectDigestInfo) {
        this.c = objectDigestInfo;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.a;
    }

    public GeneralNames getEntityName() {
        return this.b;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.d == 1) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            if (this.a != null) {
                aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.a));
            }
            if (this.b != null) {
                aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.b));
            }
            if (this.c != null) {
                aSN1EncodableVector.add(new DERTaggedObject(false, 2, this.c));
            }
            return new DERSequence(aSN1EncodableVector);
        }
        if (this.b != null) {
            return new DERTaggedObject(true, 1, this.b);
        }
        return new DERTaggedObject(true, 0, this.a);
    }
}

