/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.ASN1UTCTime;
import com.enterprisedt.bouncycastle.asn1.DERGeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.DERUTCTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;

public class Time
extends ASN1Object
implements ASN1Choice {
    ASN1Primitive a;

    public static Time getInstance(ASN1TaggedObject obj, boolean explicit) {
        return Time.getInstance(obj.getObject());
    }

    public Time(ASN1Primitive time) {
        if (!(time instanceof ASN1UTCTime) && !(time instanceof ASN1GeneralizedTime)) {
            throw new IllegalArgumentException("unknown object passed to Time");
        }
        this.a = time;
    }

    public Time(Date time) {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "Z");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        simpleDateFormat.setTimeZone(simpleTimeZone);
        String string = simpleDateFormat.format(time) + "Z";
        int n2 = Integer.parseInt(string.substring(0, 4));
        this.a = n2 < 1950 || n2 > 2049 ? new DERGeneralizedTime(string) : new DERUTCTime(string.substring(2));
    }

    public Time(Date time, Locale locale) {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "Z");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss", locale);
        simpleDateFormat.setTimeZone(simpleTimeZone);
        String string = simpleDateFormat.format(time) + "Z";
        int n2 = Integer.parseInt(string.substring(0, 4));
        this.a = n2 < 1950 || n2 > 2049 ? new DERGeneralizedTime(string) : new DERUTCTime(string.substring(2));
    }

    public static Time getInstance(Object obj) {
        if (obj == null || obj instanceof Time) {
            return (Time)obj;
        }
        if (obj instanceof ASN1UTCTime) {
            return new Time((ASN1UTCTime)obj);
        }
        if (obj instanceof ASN1GeneralizedTime) {
            return new Time((ASN1GeneralizedTime)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public String getTime() {
        if (this.a instanceof ASN1UTCTime) {
            return ((ASN1UTCTime)this.a).getAdjustedTime();
        }
        return ((ASN1GeneralizedTime)this.a).getTime();
    }

    public Date getDate() {
        try {
            if (this.a instanceof ASN1UTCTime) {
                return ((ASN1UTCTime)this.a).getAdjustedDate();
            }
            return ((ASN1GeneralizedTime)this.a).getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("invalid date string: " + parseException.getMessage());
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }

    public String toString() {
        return this.getTime();
    }
}

