/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509.qualified;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.qualified.ETSIQCObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x509.qualified.RFC3739QCObjectIdentifiers;
import java.util.Enumeration;

public class QCStatement
extends ASN1Object
implements ETSIQCObjectIdentifiers,
RFC3739QCObjectIdentifiers {
    ASN1ObjectIdentifier a;
    ASN1Encodable b;

    public static QCStatement getInstance(Object obj) {
        if (obj instanceof QCStatement) {
            return (QCStatement)obj;
        }
        if (obj != null) {
            return new QCStatement(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private QCStatement(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        this.a = ASN1ObjectIdentifier.getInstance(enumeration.nextElement());
        if (enumeration.hasMoreElements()) {
            this.b = (ASN1Encodable)enumeration.nextElement();
        }
    }

    public QCStatement(ASN1ObjectIdentifier qcStatementId) {
        this.a = qcStatementId;
        this.b = null;
    }

    public QCStatement(ASN1ObjectIdentifier qcStatementId, ASN1Encodable qcStatementInfo) {
        this.a = qcStatementId;
        this.b = qcStatementInfo;
    }

    public ASN1ObjectIdentifier getStatementId() {
        return this.a;
    }

    public ASN1Encodable getStatementInfo() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

