/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x9;

import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.anssi.ANSSINamedCurves;
import com.enterprisedt.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.enterprisedt.bouncycastle.asn1.gm.GMNamedCurves;
import com.enterprisedt.bouncycastle.asn1.nist.NISTNamedCurves;
import com.enterprisedt.bouncycastle.asn1.sec.SECNamedCurves;
import com.enterprisedt.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import com.enterprisedt.bouncycastle.asn1.x9.X962NamedCurves;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import java.util.Enumeration;
import java.util.Vector;

public class ECNamedCurveTable {
    public static X9ECParameters getByName(String name) {
        X9ECParameters x9ECParameters = X962NamedCurves.getByName(name);
        if (x9ECParameters == null) {
            x9ECParameters = SECNamedCurves.getByName(name);
        }
        if (x9ECParameters == null) {
            x9ECParameters = NISTNamedCurves.getByName(name);
        }
        if (x9ECParameters == null) {
            x9ECParameters = TeleTrusTNamedCurves.getByName(name);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ANSSINamedCurves.getByName(name);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.a(ECGOST3410NamedCurves.getByName(name));
        }
        if (x9ECParameters == null) {
            x9ECParameters = GMNamedCurves.getByName(name);
        }
        return x9ECParameters;
    }

    public static ASN1ObjectIdentifier getOID(String name) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = X962NamedCurves.getOID(name);
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = SECNamedCurves.getOID(name);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = NISTNamedCurves.getOID(name);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = TeleTrusTNamedCurves.getOID(name);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = ANSSINamedCurves.getOID(name);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = ECGOST3410NamedCurves.getOID(name);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = GMNamedCurves.getOID(name);
        }
        return aSN1ObjectIdentifier;
    }

    public static String getName(ASN1ObjectIdentifier oid) {
        String string = X962NamedCurves.getName(oid);
        if (string == null) {
            string = SECNamedCurves.getName(oid);
        }
        if (string == null) {
            string = NISTNamedCurves.getName(oid);
        }
        if (string == null) {
            string = TeleTrusTNamedCurves.getName(oid);
        }
        if (string == null) {
            string = ANSSINamedCurves.getName(oid);
        }
        if (string == null) {
            string = ECGOST3410NamedCurves.getName(oid);
        }
        if (string == null) {
            string = GMNamedCurves.getName(oid);
        }
        return string;
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier oid) {
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(oid);
        if (x9ECParameters == null) {
            x9ECParameters = SECNamedCurves.getByOID(oid);
        }
        if (x9ECParameters == null) {
            x9ECParameters = TeleTrusTNamedCurves.getByOID(oid);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ANSSINamedCurves.getByOID(oid);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.a(ECGOST3410NamedCurves.getByOID(oid));
        }
        if (x9ECParameters == null) {
            x9ECParameters = GMNamedCurves.getByOID(oid);
        }
        return x9ECParameters;
    }

    public static Enumeration getNames() {
        Vector vector = new Vector();
        ECNamedCurveTable.a(vector, X962NamedCurves.getNames());
        ECNamedCurveTable.a(vector, SECNamedCurves.getNames());
        ECNamedCurveTable.a(vector, NISTNamedCurves.getNames());
        ECNamedCurveTable.a(vector, TeleTrusTNamedCurves.getNames());
        ECNamedCurveTable.a(vector, ANSSINamedCurves.getNames());
        ECNamedCurveTable.a(vector, ECGOST3410NamedCurves.getNames());
        ECNamedCurveTable.a(vector, GMNamedCurves.getNames());
        return vector.elements();
    }

    private static void a(Vector vector, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
    }

    private static X9ECParameters a(ECDomainParameters eCDomainParameters) {
        return eCDomainParameters == null ? null : new X9ECParameters(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
    }
}

