/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x9;

import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.util.Arrays;

public class X9ECPoint
extends ASN1Object {
    private final ASN1OctetString a;
    private ECCurve b;
    private ECPoint c;

    public X9ECPoint(ECPoint p2) {
        this(p2, false);
    }

    public X9ECPoint(ECPoint p2, boolean compressed) {
        this.c = p2.normalize();
        this.a = new DEROctetString(p2.getEncoded(compressed));
    }

    public X9ECPoint(ECCurve c2, byte[] encoding) {
        this.b = c2;
        this.a = new DEROctetString(Arrays.clone(encoding));
    }

    public X9ECPoint(ECCurve c2, ASN1OctetString s2) {
        this(c2, s2.getOctets());
    }

    public byte[] getPointEncoding() {
        return Arrays.clone(this.a.getOctets());
    }

    public synchronized ECPoint getPoint() {
        if (this.c == null) {
            this.c = this.b.decodePoint(this.a.getOctets()).normalize();
        }
        return this.c;
    }

    public boolean isPointCompressed() {
        byte[] byArray = this.a.getOctets();
        return byArray != null && byArray.length > 0 && (byArray[0] == 2 || byArray[0] == 3);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

