/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.agreement.DHBasicAgreement;
import com.enterprisedt.bouncycastle.crypto.params.DHUPrivateParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHUPublicParameters;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class DHUnifiedAgreement {
    private DHUPrivateParameters a;

    public void init(CipherParameters key) {
        this.a = (DHUPrivateParameters)key;
    }

    public int getFieldSize() {
        return (this.a.getStaticPrivateKey().getParameters().getP().bitLength() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters pubKey) {
        DHUPublicParameters dHUPublicParameters = (DHUPublicParameters)pubKey;
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        DHBasicAgreement dHBasicAgreement2 = new DHBasicAgreement();
        dHBasicAgreement.init(this.a.getStaticPrivateKey());
        BigInteger bigInteger = dHBasicAgreement.calculateAgreement(dHUPublicParameters.getStaticPublicKey());
        dHBasicAgreement2.init(this.a.getEphemeralPrivateKey());
        BigInteger bigInteger2 = dHBasicAgreement2.calculateAgreement(dHUPublicParameters.getEphemeralPublicKey());
        return Arrays.concatenate(BigIntegers.asUnsignedByteArray(this.getFieldSize(), bigInteger2), BigIntegers.asUnsignedByteArray(this.getFieldSize(), bigInteger));
    }
}

