/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import com.enterprisedt.bouncycastle.crypto.params.ECDHUPrivateParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECDHUPublicParameters;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class ECDHCUnifiedAgreement {
    private ECDHUPrivateParameters a;

    public void init(CipherParameters key) {
        this.a = (ECDHUPrivateParameters)key;
    }

    public int getFieldSize() {
        return (this.a.getStaticPrivateKey().getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters pubKey) {
        ECDHUPublicParameters eCDHUPublicParameters = (ECDHUPublicParameters)pubKey;
        ECDHCBasicAgreement eCDHCBasicAgreement = new ECDHCBasicAgreement();
        ECDHCBasicAgreement eCDHCBasicAgreement2 = new ECDHCBasicAgreement();
        eCDHCBasicAgreement.init(this.a.getStaticPrivateKey());
        BigInteger bigInteger = eCDHCBasicAgreement.calculateAgreement(eCDHUPublicParameters.getStaticPublicKey());
        eCDHCBasicAgreement2.init(this.a.getEphemeralPrivateKey());
        BigInteger bigInteger2 = eCDHCBasicAgreement2.calculateAgreement(eCDHUPublicParameters.getEphemeralPublicKey());
        return Arrays.concatenate(BigIntegers.asUnsignedByteArray(this.getFieldSize(), bigInteger2), BigIntegers.asUnsignedByteArray(this.getFieldSize(), bigInteger));
    }
}

