/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.agreement;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithUKM;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class ECVKOAgreement {
    private final Digest a;
    private ECPrivateKeyParameters b;
    private BigInteger c;

    public ECVKOAgreement(Digest digest) {
        this.a = digest;
    }

    public void init(CipherParameters key) {
        ParametersWithUKM parametersWithUKM = (ParametersWithUKM)key;
        this.b = (ECPrivateKeyParameters)parametersWithUKM.getParameters();
        this.c = ECVKOAgreement.a(parametersWithUKM.getUKM());
    }

    public int getFieldSize() {
        return (this.b.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters pubKey) {
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)pubKey;
        ECDomainParameters eCDomainParameters = this.b.getParameters();
        if (!eCDomainParameters.equals(eCPublicKeyParameters.getParameters())) {
            throw new IllegalStateException("ECVKO public key has wrong domain parameters");
        }
        BigInteger bigInteger = eCDomainParameters.getH().multiply(this.c).multiply(this.b.getD()).mod(eCDomainParameters.getN());
        ECPoint eCPoint = ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPublicKeyParameters.getQ());
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECDHC");
        }
        ECPoint eCPoint2 = eCPoint.multiply(bigInteger).normalize();
        if (eCPoint2.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECVKO");
        }
        return this.a(eCPoint2);
    }

    private static BigInteger a(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 != byArray2.length; ++i2) {
            byArray2[i2] = byArray[byArray.length - i2 - 1];
        }
        return new BigInteger(1, byArray2);
    }

    private byte[] a(ECPoint eCPoint) {
        int n2;
        BigInteger bigInteger = eCPoint.getAffineXCoord().toBigInteger();
        BigInteger bigInteger2 = eCPoint.getAffineYCoord().toBigInteger();
        int n3 = bigInteger.toByteArray().length > 33 ? 64 : 32;
        byte[] byArray = new byte[2 * n3];
        byte[] byArray2 = BigIntegers.asUnsignedByteArray(n3, bigInteger);
        byte[] byArray3 = BigIntegers.asUnsignedByteArray(n3, bigInteger2);
        for (n2 = 0; n2 != n3; ++n2) {
            byArray[n2] = byArray2[n3 - n2 - 1];
        }
        for (n2 = 0; n2 != n3; ++n2) {
            byArray[n3 + n2] = byArray3[n3 - n2 - 1];
        }
        this.a.update(byArray, 0, byArray.length);
        byte[] byArray4 = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray4, 0);
        return byArray4;
    }
}

