/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;

public class Blake2sDigest
implements ExtendedDigest {
    private static final int[] a = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final byte[][] b = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3}, {11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4}, {7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8}, {9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13}, {2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9}, {12, 5, 1, 15, 14, 13, 4, 10, 0, 7, 6, 3, 9, 2, 8, 11}, {13, 11, 7, 14, 12, 1, 3, 9, 5, 0, 15, 4, 8, 6, 2, 10}, {6, 15, 14, 9, 11, 3, 0, 8, 12, 2, 13, 7, 1, 4, 10, 5}, {10, 2, 8, 4, 7, 6, 1, 5, 15, 11, 9, 14, 3, 12, 13, 0}};
    private int c = 32;
    private int d = 0;
    private byte[] e = null;
    private byte[] f = null;
    private byte[] g = null;
    private byte[] h = null;
    private int i = 0;
    private int[] j = new int[16];
    private int[] k = null;
    private int l = 0;
    private int m = 0;
    private int n = 0;

    public Blake2sDigest() {
        this(256);
    }

    public Blake2sDigest(Blake2sDigest digest) {
        this.i = digest.i;
        this.h = Arrays.clone(digest.h);
        this.d = digest.d;
        this.g = Arrays.clone(digest.g);
        this.c = digest.c;
        this.k = Arrays.clone(digest.k);
        this.f = Arrays.clone(digest.f);
    }

    public Blake2sDigest(int digestBits) {
        if (digestBits < 8 || digestBits > 256 || digestBits % 8 != 0) {
            throw new IllegalArgumentException("BLAKE2s digest bit length must be a multiple of 8 and not greater than 256");
        }
        this.h = new byte[64];
        this.d = 0;
        this.c = digestBits / 8;
        this.a();
    }

    public Blake2sDigest(byte[] key) {
        this.h = new byte[64];
        if (key != null) {
            if (key.length > 32) {
                throw new IllegalArgumentException("Keys > 32 are not supported");
            }
            this.g = new byte[key.length];
            System.arraycopy(key, 0, this.g, 0, key.length);
            this.d = key.length;
            System.arraycopy(key, 0, this.h, 0, key.length);
            this.i = 64;
        }
        this.c = 32;
        this.a();
    }

    public Blake2sDigest(byte[] key, int digestBytes, byte[] salt, byte[] personalization) {
        this.h = new byte[64];
        if (digestBytes < 1 || digestBytes > 32) {
            throw new IllegalArgumentException("Invalid digest length (required: 1 - 32)");
        }
        this.c = digestBytes;
        if (salt != null) {
            if (salt.length != 8) {
                throw new IllegalArgumentException("Salt length must be exactly 8 bytes");
            }
            this.e = new byte[8];
            System.arraycopy(salt, 0, this.e, 0, salt.length);
        }
        if (personalization != null) {
            if (personalization.length != 8) {
                throw new IllegalArgumentException("Personalization length must be exactly 8 bytes");
            }
            this.f = new byte[8];
            System.arraycopy(personalization, 0, this.f, 0, personalization.length);
        }
        if (key != null) {
            if (key.length > 32) {
                throw new IllegalArgumentException("Keys > 32 bytes are not supported");
            }
            this.g = new byte[key.length];
            System.arraycopy(key, 0, this.g, 0, key.length);
            this.d = key.length;
            System.arraycopy(key, 0, this.h, 0, key.length);
            this.i = 64;
        }
        this.a();
    }

    private void a() {
        if (this.k == null) {
            this.k = new int[8];
            this.k[0] = a[0] ^ (this.c | this.d << 8 | 0x1010000);
            this.k[1] = a[1];
            this.k[2] = a[2];
            this.k[3] = a[3];
            this.k[4] = a[4];
            this.k[5] = a[5];
            if (this.e != null) {
                this.k[4] = this.k[4] ^ Pack.littleEndianToInt(this.e, 0);
                this.k[5] = this.k[5] ^ Pack.littleEndianToInt(this.e, 4);
            }
            this.k[6] = a[6];
            this.k[7] = a[7];
            if (this.f != null) {
                this.k[6] = this.k[6] ^ Pack.littleEndianToInt(this.f, 0);
                this.k[7] = this.k[7] ^ Pack.littleEndianToInt(this.f, 4);
            }
        }
    }

    private void b() {
        System.arraycopy(this.k, 0, this.j, 0, this.k.length);
        System.arraycopy(a, 0, this.j, this.k.length, 4);
        this.j[12] = this.l ^ a[4];
        this.j[13] = this.m ^ a[5];
        this.j[14] = this.n ^ a[6];
        this.j[15] = a[7];
    }

    @Override
    public void update(byte b2) {
        int n2 = 64 - this.i;
        if (n2 == 0) {
            this.l += 64;
            if (this.l == 0) {
                ++this.m;
            }
            this.a(this.h, 0);
            Arrays.fill(this.h, (byte)0);
            this.h[0] = b2;
            this.i = 1;
        } else {
            this.h[this.i] = b2;
            ++this.i;
        }
    }

    @Override
    public void update(byte[] message, int offset, int len) {
        int n2;
        if (message == null || len == 0) {
            return;
        }
        int n3 = 0;
        if (this.i != 0) {
            n3 = 64 - this.i;
            if (n3 < len) {
                System.arraycopy(message, offset, this.h, this.i, n3);
                this.l += 64;
                if (this.l == 0) {
                    ++this.m;
                }
                this.a(this.h, 0);
                this.i = 0;
                Arrays.fill(this.h, (byte)0);
            } else {
                System.arraycopy(message, offset, this.h, this.i, len);
                this.i += len;
                return;
            }
        }
        int n4 = offset + len - 64;
        for (n2 = offset + n3; n2 < n4; n2 += 64) {
            this.l += 64;
            if (this.l == 0) {
                ++this.m;
            }
            this.a(message, n2);
        }
        System.arraycopy(message, n2, this.h, 0, offset + len - n2);
        this.i += offset + len - n2;
    }

    @Override
    public int doFinal(byte[] out, int outOffset) {
        this.n = -1;
        this.l += this.i;
        if (this.l < 0 && this.i > -this.l) {
            ++this.m;
        }
        this.a(this.h, 0);
        Arrays.fill(this.h, (byte)0);
        Arrays.fill(this.j, 0);
        for (int i2 = 0; i2 < this.k.length && i2 * 4 < this.c; ++i2) {
            byte[] byArray = Pack.intToLittleEndian(this.k[i2]);
            if (i2 * 4 < this.c - 4) {
                System.arraycopy(byArray, 0, out, outOffset + i2 * 4, 4);
                continue;
            }
            System.arraycopy(byArray, 0, out, outOffset + i2 * 4, this.c - i2 * 4);
        }
        Arrays.fill(this.k, 0);
        this.reset();
        return this.c;
    }

    @Override
    public void reset() {
        this.i = 0;
        this.n = 0;
        this.l = 0;
        this.m = 0;
        this.k = null;
        Arrays.fill(this.h, (byte)0);
        if (this.g != null) {
            System.arraycopy(this.g, 0, this.h, 0, this.g.length);
            this.i = 64;
        }
        this.a();
    }

    private void a(byte[] byArray, int n2) {
        int n3;
        this.b();
        int[] nArray = new int[16];
        for (n3 = 0; n3 < 16; ++n3) {
            nArray[n3] = Pack.littleEndianToInt(byArray, n2 + n3 * 4);
        }
        for (n3 = 0; n3 < 10; ++n3) {
            this.a(nArray[b[n3][0]], nArray[b[n3][1]], 0, 4, 8, 12);
            this.a(nArray[b[n3][2]], nArray[b[n3][3]], 1, 5, 9, 13);
            this.a(nArray[b[n3][4]], nArray[b[n3][5]], 2, 6, 10, 14);
            this.a(nArray[b[n3][6]], nArray[b[n3][7]], 3, 7, 11, 15);
            this.a(nArray[b[n3][8]], nArray[b[n3][9]], 0, 5, 10, 15);
            this.a(nArray[b[n3][10]], nArray[b[n3][11]], 1, 6, 11, 12);
            this.a(nArray[b[n3][12]], nArray[b[n3][13]], 2, 7, 8, 13);
            this.a(nArray[b[n3][14]], nArray[b[n3][15]], 3, 4, 9, 14);
        }
        for (n3 = 0; n3 < this.k.length; ++n3) {
            this.k[n3] = this.k[n3] ^ this.j[n3] ^ this.j[n3 + 8];
        }
    }

    private void a(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.j[n4] = this.j[n4] + this.j[n5] + n2;
        this.j[n7] = this.a(this.j[n7] ^ this.j[n4], 16);
        this.j[n6] = this.j[n6] + this.j[n7];
        this.j[n5] = this.a(this.j[n5] ^ this.j[n6], 12);
        this.j[n4] = this.j[n4] + this.j[n5] + n3;
        this.j[n7] = this.a(this.j[n7] ^ this.j[n4], 8);
        this.j[n6] = this.j[n6] + this.j[n7];
        this.j[n5] = this.a(this.j[n5] ^ this.j[n6], 7);
    }

    private int a(int n2, int n3) {
        return n2 >>> n3 | n2 << 32 - n3;
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2s";
    }

    @Override
    public int getDigestSize() {
        return this.c;
    }

    @Override
    public int getByteLength() {
        return 64;
    }

    public void clearKey() {
        if (this.g != null) {
            Arrays.fill(this.g, (byte)0);
            Arrays.fill(this.h, (byte)0);
        }
    }

    public void clearSalt() {
        if (this.e != null) {
            Arrays.fill(this.e, (byte)0);
        }
    }
}

