/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.util.Memoable;
import com.enterprisedt.bouncycastle.util.Pack;

public abstract class GeneralDigest
implements ExtendedDigest,
Memoable {
    private final byte[] a = new byte[4];
    private int b;
    private long c;

    protected GeneralDigest() {
        this.b = 0;
    }

    protected GeneralDigest(GeneralDigest t2) {
        this.copyIn(t2);
    }

    protected GeneralDigest(byte[] encodedState) {
        System.arraycopy(encodedState, 0, this.a, 0, this.a.length);
        this.b = Pack.bigEndianToInt(encodedState, 4);
        this.c = Pack.bigEndianToLong(encodedState, 8);
    }

    protected void copyIn(GeneralDigest t2) {
        System.arraycopy(t2.a, 0, this.a, 0, t2.a.length);
        this.b = t2.b;
        this.c = t2.c;
    }

    @Override
    public void update(byte in) {
        this.a[this.b++] = in;
        if (this.b == this.a.length) {
            this.processWord(this.a, 0);
            this.b = 0;
        }
        ++this.c;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        len = Math.max(0, len);
        int n2 = 0;
        if (this.b != 0) {
            while (n2 < len) {
                this.a[this.b++] = in[inOff + n2++];
                if (this.b != 4) continue;
                this.processWord(this.a, 0);
                this.b = 0;
                break;
            }
        }
        int n3 = (len - n2 & 0xFFFFFFFC) + n2;
        while (n2 < n3) {
            this.processWord(in, inOff + n2);
            n2 += 4;
        }
        while (n2 < len) {
            this.a[this.b++] = in[inOff + n2++];
        }
        this.c += (long)len;
    }

    public void finish() {
        long l2 = this.c << 3;
        this.update((byte)-128);
        while (this.b != 0) {
            this.update((byte)0);
        }
        this.processLength(l2);
        this.processBlock();
    }

    @Override
    public void reset() {
        this.c = 0L;
        this.b = 0;
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2] = 0;
        }
    }

    protected void populateState(byte[] state) {
        System.arraycopy(this.a, 0, state, 0, this.b);
        Pack.intToBigEndian(this.b, state, 4);
        Pack.longToBigEndian(this.c, state, 8);
    }

    @Override
    public int getByteLength() {
        return 64;
    }

    protected abstract void processWord(byte[] var1, int var2);

    protected abstract void processLength(long var1);

    protected abstract void processBlock();
}

