/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.Xof;
import com.enterprisedt.bouncycastle.crypto.digests.KeccakDigest;

public class SHAKEDigest
extends KeccakDigest
implements Xof {
    private static int a(int n2) {
        switch (n2) {
            case 128: 
            case 256: {
                return n2;
            }
        }
        throw new IllegalArgumentException("'bitLength' " + n2 + " not supported for SHAKE");
    }

    public SHAKEDigest() {
        this(128);
    }

    public SHAKEDigest(int bitLength) {
        super(SHAKEDigest.a(bitLength));
    }

    public SHAKEDigest(SHAKEDigest source) {
        super(source);
    }

    @Override
    public String getAlgorithmName() {
        return "SHAKE" + this.fixedOutputLength;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        return this.doFinal(out, outOff, this.getDigestSize());
    }

    @Override
    public int doFinal(byte[] out, int outOff, int outLen) {
        int n2 = this.doOutput(out, outOff, outLen);
        this.reset();
        return n2;
    }

    @Override
    public int doOutput(byte[] out, int outOff, int outLen) {
        if (!this.squeezing) {
            this.absorbBits(15, 4);
        }
        this.squeeze(out, outOff, (long)outLen * 8L);
        return outLen;
    }

    @Override
    protected int doFinal(byte[] out, int outOff, byte partialByte, int partialBits) {
        return this.doFinal(out, outOff, this.getDigestSize(), partialByte, partialBits);
    }

    protected int doFinal(byte[] out, int outOff, int outLen, byte partialByte, int partialBits) {
        if (partialBits < 0 || partialBits > 7) {
            throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
        }
        int n2 = partialByte & (1 << partialBits) - 1 | 15 << partialBits;
        int n3 = partialBits + 4;
        if (n3 >= 8) {
            this.absorb(new byte[]{(byte)n2}, 0, 1);
            n3 -= 8;
            n2 >>>= 8;
        }
        if (n3 > 0) {
            this.absorbBits(n2, n3);
        }
        this.squeeze(out, outOff, (long)outLen * 8L);
        this.reset();
        return outLen;
    }
}

