/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.crypto.digests.SkeinEngine;
import com.enterprisedt.bouncycastle.crypto.params.SkeinParameters;
import com.enterprisedt.bouncycastle.util.Memoable;

public class SkeinDigest
implements ExtendedDigest,
Memoable {
    public static final int SKEIN_256 = 256;
    public static final int SKEIN_512 = 512;
    public static final int SKEIN_1024 = 1024;
    private SkeinEngine a;

    public SkeinDigest(int stateSizeBits, int digestSizeBits) {
        this.a = new SkeinEngine(stateSizeBits, digestSizeBits);
        this.init(null);
    }

    public SkeinDigest(SkeinDigest digest) {
        this.a = new SkeinEngine(digest.a);
    }

    @Override
    public void reset(Memoable other) {
        SkeinDigest skeinDigest = (SkeinDigest)other;
        this.a.reset(skeinDigest.a);
    }

    @Override
    public Memoable copy() {
        return new SkeinDigest(this);
    }

    @Override
    public String getAlgorithmName() {
        return "Skein-" + this.a.getBlockSize() * 8 + "-" + this.a.getOutputSize() * 8;
    }

    @Override
    public int getDigestSize() {
        return this.a.getOutputSize();
    }

    @Override
    public int getByteLength() {
        return this.a.getBlockSize();
    }

    public void init(SkeinParameters params) {
        this.a.init(params);
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    @Override
    public void update(byte in) {
        this.a.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.a.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        return this.a.doFinal(out, outOff);
    }
}

