/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.digests;

import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.engines.ThreefishEngine;
import com.enterprisedt.bouncycastle.crypto.params.SkeinParameters;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Memoable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SkeinEngine
implements Memoable {
    public static final int SKEIN_256 = 256;
    public static final int SKEIN_512 = 512;
    public static final int SKEIN_1024 = 1024;
    private static final Hashtable c = new Hashtable();
    final ThreefishEngine a;
    private final int d;
    long[] b;
    private long[] e;
    private byte[] f;
    private Parameter[] g;
    private Parameter[] h;
    private final b i;
    private final byte[] j = new byte[1];

    private static void a(int n2, int n3, long[] lArray) {
        c.put(SkeinEngine.a(n2 / 8, n3 / 8), lArray);
    }

    private static Integer a(int n2, int n3) {
        return new Integer(n3 << 16 | n2);
    }

    public SkeinEngine(int blockSizeBits, int outputSizeBits) {
        if (outputSizeBits % 8 != 0) {
            throw new IllegalArgumentException("Output size must be a multiple of 8 bits. :" + outputSizeBits);
        }
        this.d = outputSizeBits / 8;
        this.a = new ThreefishEngine(blockSizeBits);
        this.i = new b(this.a.getBlockSize());
    }

    public SkeinEngine(SkeinEngine engine) {
        this(engine.getBlockSize() * 8, engine.getOutputSize() * 8);
        this.a(engine);
    }

    private void a(SkeinEngine skeinEngine) {
        this.i.a(skeinEngine.i);
        this.b = Arrays.clone(skeinEngine.b, this.b);
        this.e = Arrays.clone(skeinEngine.e, this.e);
        this.f = Arrays.clone(skeinEngine.f, this.f);
        this.g = SkeinEngine.a(skeinEngine.g, this.g);
        this.h = SkeinEngine.a(skeinEngine.h, this.h);
    }

    private static Parameter[] a(Parameter[] parameterArray, Parameter[] parameterArray2) {
        if (parameterArray == null) {
            return null;
        }
        if (parameterArray2 == null || parameterArray2.length != parameterArray.length) {
            parameterArray2 = new Parameter[parameterArray.length];
        }
        System.arraycopy(parameterArray, 0, parameterArray2, 0, parameterArray2.length);
        return parameterArray2;
    }

    @Override
    public Memoable copy() {
        return new SkeinEngine(this);
    }

    @Override
    public void reset(Memoable other) {
        SkeinEngine skeinEngine = (SkeinEngine)other;
        if (this.getBlockSize() != skeinEngine.getBlockSize() || this.d != skeinEngine.d) {
            throw new IllegalArgumentException("Incompatible parameters in provided SkeinEngine.");
        }
        this.a(skeinEngine);
    }

    public int getOutputSize() {
        return this.d;
    }

    public int getBlockSize() {
        return this.a.getBlockSize();
    }

    public void init(SkeinParameters params) {
        this.b = null;
        this.f = null;
        this.g = null;
        this.h = null;
        if (params != null) {
            byte[] byArray = params.getKey();
            if (byArray.length < 16) {
                throw new IllegalArgumentException("Skein key must be at least 128 bits.");
            }
            this.a(params.getParameters());
        }
        this.a();
        this.a(48);
    }

    private void a(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        Vector<Parameter> vector = new Vector<Parameter>();
        Vector<Parameter> vector2 = new Vector<Parameter>();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            byte[] byArray = (byte[])hashtable.get(n2);
            if (n2 == 0) {
                this.f = byArray;
                continue;
            }
            if (n2 < 48) {
                vector.addElement(new Parameter(n2, byArray));
                continue;
            }
            vector2.addElement(new Parameter(n2, byArray));
        }
        this.g = new Parameter[vector.size()];
        vector.copyInto(this.g);
        SkeinEngine.a(this.g);
        this.h = new Parameter[vector2.size()];
        vector2.copyInto(this.h);
        SkeinEngine.a(this.h);
    }

    private static void a(Parameter[] parameterArray) {
        if (parameterArray == null) {
            return;
        }
        for (int i2 = 1; i2 < parameterArray.length; ++i2) {
            Parameter parameter = parameterArray[i2];
            for (int i3 = i2; i3 > 0 && parameter.getType() < parameterArray[i3 - 1].getType(); --i3) {
                parameterArray[i3] = parameterArray[i3 - 1];
            }
            parameterArray[i3] = parameter;
        }
    }

    private void a() {
        long[] lArray = (long[])c.get(SkeinEngine.a(this.getBlockSize(), this.getOutputSize()));
        if (this.f == null && lArray != null) {
            this.b = Arrays.clone(lArray);
        } else {
            this.b = new long[this.getBlockSize() / 8];
            if (this.f != null) {
                this.a(0, this.f);
            }
            this.a(4, new a(this.d * 8).a());
        }
        if (this.g != null) {
            for (int i2 = 0; i2 < this.g.length; ++i2) {
                Parameter parameter = this.g[i2];
                this.a(parameter.getType(), parameter.getValue());
            }
        }
        this.e = Arrays.clone(this.b);
    }

    public void reset() {
        System.arraycopy(this.e, 0, this.b, 0, this.b.length);
        this.a(48);
    }

    private void a(int n2, byte[] byArray) {
        this.a(n2);
        this.i.a(byArray, 0, byArray.length, this.b);
        this.b();
    }

    private void a(int n2) {
        this.i.a(n2);
    }

    private void b() {
        this.i.a(this.b);
    }

    private void c() {
        if (this.i == null) {
            throw new IllegalArgumentException("Skein engine is not initialised.");
        }
    }

    public void update(byte in) {
        this.j[0] = in;
        this.update(this.j, 0, 1);
    }

    public void update(byte[] in, int inOff, int len) {
        this.c();
        this.i.a(in, inOff, len, this.b);
    }

    public int doFinal(byte[] out, int outOff) {
        int n2;
        this.c();
        if (out.length < outOff + this.d) {
            throw new OutputLengthException("Output buffer is too short to hold output");
        }
        this.b();
        if (this.h != null) {
            for (n2 = 0; n2 < this.h.length; ++n2) {
                Parameter parameter = this.h[n2];
                this.a(parameter.getType(), parameter.getValue());
            }
        }
        n2 = this.getBlockSize();
        int n3 = (this.d + n2 - 1) / n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = Math.min(n2, this.d - i2 * n2);
            this.a(i2, out, outOff + i2 * n2, n4);
        }
        this.reset();
        return this.d;
    }

    private void a(long l2, byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[8];
        ThreefishEngine.wordToBytes(l2, byArray2, 0);
        long[] lArray = new long[this.b.length];
        this.a(63);
        this.i.a(byArray2, 0, byArray2.length, lArray);
        this.i.a(lArray);
        int n4 = (n3 + 8 - 1) / 8;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = Math.min(8, n3 - i2 * 8);
            if (n5 == 8) {
                ThreefishEngine.wordToBytes(lArray[i2], byArray, n2 + i2 * 8);
                continue;
            }
            ThreefishEngine.wordToBytes(lArray[i2], byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n2 + i2 * 8, n5);
        }
    }

    static {
        SkeinEngine.a(256, 128, new long[]{-2228972824489528736L, -8629553674646093540L, 1155188648486244218L, -3677226592081559102L});
        SkeinEngine.a(256, 160, new long[]{1450197650740764312L, 3081844928540042640L, -3136097061834271170L, 3301952811952417661L});
        SkeinEngine.a(256, 224, new long[]{-4176654842910610933L, -8688192972455077604L, -7364642305011795836L, 4056579644589979102L});
        SkeinEngine.a(256, 256, new long[]{-243853671043386295L, 3443677322885453875L, -5531612722399640561L, 7662005193972177513L});
        SkeinEngine.a(512, 128, new long[]{-6288014694233956526L, 2204638249859346602L, 3502419045458743507L, -4829063503441264548L, 983504137758028059L, 1880512238245786339L, -6715892782214108542L, 7602827311880509485L});
        SkeinEngine.a(512, 160, new long[]{2934123928682216849L, -4399710721982728305L, 1684584802963255058L, 5744138295201861711L, 2444857010922934358L, -2807833639722848072L, -5121587834665610502L, 118355523173251694L});
        SkeinEngine.a(512, 224, new long[]{-3688341020067007964L, -3772225436291745297L, -8300862168937575580L, 4146387520469897396L, 1106145742801415120L, 7455425944880474941L, -7351063101234211863L, -7048981346965512457L});
        SkeinEngine.a(512, 384, new long[]{-6631894876634615969L, -5692838220127733084L, -7099962856338682626L, -2911352911530754598L, 2000907093792408677L, 9140007292425499655L, 6093301768906360022L, 2769176472213098488L});
        SkeinEngine.a(512, 512, new long[]{5261240102383538638L, 978932832955457283L, -8083517948103779378L, -7339365279355032399L, 6752626034097301424L, -1531723821829733388L, -7417126464950782685L, -5901786942805128141L});
    }

    private class b {
        private final c b = new c();
        private byte[] c;
        private int d;
        private long[] e;

        public b(int n2) {
            this.c = new byte[n2];
            this.e = new long[this.c.length / 8];
        }

        public void a(b b2) {
            this.c = Arrays.clone(b2.c, this.c);
            this.d = b2.d;
            this.e = Arrays.clone(b2.e, this.e);
            this.b.a(b2.b);
        }

        public void a(int n2) {
            this.b.a();
            this.b.a(n2);
            this.d = 0;
        }

        public void a(byte[] byArray, int n2, int n3, long[] lArray) {
            int n4 = 0;
            while (n3 > n4) {
                if (this.d == this.c.length) {
                    this.b(lArray);
                    this.b.a(false);
                    this.d = 0;
                }
                int n5 = Math.min(n3 - n4, this.c.length - this.d);
                System.arraycopy(byArray, n2 + n4, this.c, this.d, n5);
                n4 += n5;
                this.d += n5;
                this.b.b(n5);
            }
        }

        private void b(long[] lArray) {
            int n2;
            SkeinEngine.this.a.init(true, SkeinEngine.this.b, this.b.e());
            for (n2 = 0; n2 < this.e.length; ++n2) {
                this.e[n2] = ThreefishEngine.bytesToWord(this.c, n2 * 8);
            }
            SkeinEngine.this.a.processBlock(this.e, lArray);
            for (n2 = 0; n2 < lArray.length; ++n2) {
                int n3 = n2;
                lArray[n3] = lArray[n3] ^ this.e[n2];
            }
        }

        public void a(long[] lArray) {
            for (int i2 = this.d; i2 < this.c.length; ++i2) {
                this.c[i2] = 0;
            }
            this.b.b(true);
            this.b(lArray);
        }
    }

    private static class c {
        private long[] a = new long[2];
        private boolean b;

        public c() {
            this.a();
        }

        public void a(c c2) {
            this.a = Arrays.clone(c2.a, this.a);
            this.b = c2.b;
        }

        public void a() {
            this.a[0] = 0L;
            this.a[1] = 0L;
            this.b = false;
            this.a(true);
        }

        public void a(int n2) {
            this.a[1] = this.a[1] & 0xFFFFFFC000000000L | ((long)n2 & 0x3FL) << 56;
        }

        public int b() {
            return (int)(this.a[1] >>> 56 & 0x3FL);
        }

        public void a(boolean bl) {
            this.a[1] = bl ? this.a[1] | 0x4000000000000000L : this.a[1] & 0xBFFFFFFFFFFFFFFFL;
        }

        public boolean c() {
            return (this.a[1] & 0x4000000000000000L) != 0L;
        }

        public void b(boolean bl) {
            this.a[1] = bl ? this.a[1] | Long.MIN_VALUE : this.a[1] & Long.MAX_VALUE;
        }

        public boolean d() {
            return (this.a[1] & Long.MIN_VALUE) != 0L;
        }

        public void b(int n2) {
            if (this.b) {
                long[] lArray = new long[]{this.a[0] & 0xFFFFFFFFL, this.a[0] >>> 32 & 0xFFFFFFFFL, this.a[1] & 0xFFFFFFFFL};
                long l2 = n2;
                for (int i2 = 0; i2 < lArray.length; ++i2) {
                    lArray[i2] = l2 += lArray[i2];
                    l2 >>>= 32;
                }
                this.a[0] = (lArray[1] & 0xFFFFFFFFL) << 32 | lArray[0] & 0xFFFFFFFFL;
                this.a[1] = this.a[1] & 0xFFFFFFFF00000000L | lArray[2] & 0xFFFFFFFFL;
            } else {
                long l3 = this.a[0];
                this.a[0] = l3 += (long)n2;
                if (l3 > 9223372034707292160L) {
                    this.b = true;
                }
            }
        }

        public long[] e() {
            return this.a;
        }

        public String toString() {
            return this.b() + " first: " + this.c() + ", final: " + this.d();
        }
    }

    public static class Parameter {
        private int a;
        private byte[] b;

        public Parameter(int type, byte[] value) {
            this.a = type;
            this.b = value;
        }

        public int getType() {
            return this.a;
        }

        public byte[] getValue() {
            return this.b;
        }
    }

    private static class a {
        private byte[] a = new byte[32];

        public a(long l2) {
            this.a[0] = 83;
            this.a[1] = 72;
            this.a[2] = 65;
            this.a[3] = 51;
            this.a[4] = 1;
            this.a[5] = 0;
            ThreefishEngine.wordToBytes(l2, this.a, 8);
        }

        public byte[] a() {
            return this.a;
        }
    }
}

