/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.encodings;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;

public class PKCS1Encoding
implements AsymmetricBlockCipher {
    public static final String STRICT_LENGTH_ENABLED_PROPERTY = "com.enterprisedt.bouncycastle.pkcs1.strict";
    public static final String NOT_STRICT_LENGTH_ENABLED_PROPERTY = "com.enterprisedt.bouncycastle.pkcs1.not_strict";
    private SecureRandom a;
    private AsymmetricBlockCipher b;
    private boolean c;
    private boolean d;
    private boolean e;
    private int f = -1;
    private byte[] g = null;
    private byte[] h;

    public PKCS1Encoding(AsymmetricBlockCipher cipher) {
        this.b = cipher;
        this.e = this.a();
    }

    public PKCS1Encoding(AsymmetricBlockCipher cipher, int pLen) {
        this.b = cipher;
        this.e = this.a();
        this.f = pLen;
    }

    public PKCS1Encoding(AsymmetricBlockCipher cipher, byte[] fallback) {
        this.b = cipher;
        this.e = this.a();
        this.g = fallback;
        this.f = fallback.length;
    }

    private boolean a() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(PKCS1Encoding.STRICT_LENGTH_ENABLED_PROPERTY);
            }
        });
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(PKCS1Encoding.NOT_STRICT_LENGTH_ENABLED_PROPERTY);
            }
        });
        if (string2 != null) {
            return !string2.equals("true");
        }
        return string == null || string.equals("true");
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.b;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
            this.a = parametersWithRandom.getRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            asymmetricKeyParameter = (AsymmetricKeyParameter)param;
            if (!asymmetricKeyParameter.isPrivate() && forEncryption) {
                this.a = CryptoServicesRegistrar.getSecureRandom();
            }
        }
        this.b.init(forEncryption, param);
        this.d = asymmetricKeyParameter.isPrivate();
        this.c = forEncryption;
        this.h = new byte[this.b.getOutputBlockSize()];
        if (this.f > 0 && this.g == null && this.a == null) {
            throw new IllegalArgumentException("encoder requires random");
        }
    }

    @Override
    public int getInputBlockSize() {
        int n2 = this.b.getInputBlockSize();
        if (this.c) {
            return n2 - 10;
        }
        return n2;
    }

    @Override
    public int getOutputBlockSize() {
        int n2 = this.b.getOutputBlockSize();
        if (this.c) {
            return n2;
        }
        return n2 - 10;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.c) {
            return this.a(in, inOff, inLen);
        }
        return this.c(in, inOff, inLen);
    }

    private byte[] a(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (n3 > this.getInputBlockSize()) {
            throw new IllegalArgumentException("input data too large");
        }
        byte[] byArray2 = new byte[this.b.getInputBlockSize()];
        if (this.d) {
            byArray2[0] = 1;
            for (int i2 = 1; i2 != byArray2.length - n3 - 1; ++i2) {
                byArray2[i2] = -1;
            }
        } else {
            this.a.nextBytes(byArray2);
            byArray2[0] = 2;
            for (int i3 = 1; i3 != byArray2.length - n3 - 1; ++i3) {
                while (byArray2[i3] == 0) {
                    byArray2[i3] = (byte)this.a.nextInt();
                }
            }
        }
        byArray2[byArray2.length - n3 - 1] = 0;
        System.arraycopy(byArray, n2, byArray2, byArray2.length - n3, n3);
        return this.b.processBlock(byArray2, 0, byArray2.length);
    }

    private static int a(byte[] byArray, int n2) {
        int n3 = 0;
        n3 |= byArray[0] ^ 2;
        int n4 = byArray.length - (n2 + 1);
        for (int i2 = 1; i2 < n4; ++i2) {
            int n5 = byArray[i2];
            n5 |= n5 >> 1;
            n5 |= n5 >> 2;
            n5 |= n5 >> 4;
            n3 |= (n5 & 1) - 1;
        }
        n3 |= byArray[byArray.length - (n2 + 1)];
        n3 |= n3 >> 1;
        n3 |= n3 >> 2;
        n3 |= n3 >> 4;
        return ~((n3 & 1) - 1);
    }

    private byte[] b(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte[] byArray2;
        if (!this.d) {
            throw new InvalidCipherTextException("sorry, this method is only for decryption, not for signing");
        }
        byte[] byArray3 = this.b.processBlock(byArray, n2, n3);
        if (this.g == null) {
            byArray2 = new byte[this.f];
            this.a.nextBytes(byArray2);
        } else {
            byArray2 = this.g;
        }
        byte[] byArray4 = this.e & byArray3.length != this.b.getOutputBlockSize() ? this.h : byArray3;
        int n4 = PKCS1Encoding.a(byArray4, this.f);
        byte[] byArray5 = new byte[this.f];
        for (int i2 = 0; i2 < this.f; ++i2) {
            byArray5[i2] = (byte)(byArray4[i2 + (byArray4.length - this.f)] & ~n4 | byArray2[i2] & n4);
        }
        Arrays.fill(byArray4, (byte)0);
        return byArray5;
    }

    private byte[] c(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (this.f != -1) {
            return this.b(byArray, n2, n3);
        }
        byte[] byArray2 = this.b.processBlock(byArray, n2, n3);
        boolean bl = this.e & byArray2.length != this.b.getOutputBlockSize();
        byte[] byArray3 = byArray2.length < this.getOutputBlockSize() ? this.h : byArray2;
        byte by = byArray3[0];
        boolean bl2 = this.d ? by != 2 : by != 1;
        int n4 = this.a(by, byArray3);
        if (bl2 | ++n4 < 10) {
            Arrays.fill(byArray3, (byte)0);
            throw new InvalidCipherTextException("block incorrect");
        }
        if (bl) {
            Arrays.fill(byArray3, (byte)0);
            throw new InvalidCipherTextException("block incorrect size");
        }
        byte[] byArray4 = new byte[byArray3.length - n4];
        System.arraycopy(byArray3, n4, byArray4, 0, byArray4.length);
        return byArray4;
    }

    private int a(byte by, byte[] byArray) throws InvalidCipherTextException {
        int n2 = -1;
        boolean bl = false;
        for (int i2 = 1; i2 != byArray.length; ++i2) {
            byte by2 = byArray[i2];
            if (by2 == 0 & n2 < 0) {
                n2 = i2;
            }
            bl |= by == 1 & n2 < 0 & by2 != -1;
        }
        if (bl) {
            return -1;
        }
        return n2;
    }
}

