/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.engines.GOST28147Engine;
import com.enterprisedt.bouncycastle.crypto.engines.GOST28147WrapEngine;
import com.enterprisedt.bouncycastle.crypto.modes.GCFBBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithSBox;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithUKM;
import com.enterprisedt.bouncycastle.util.Pack;

public class CryptoProWrapEngine
extends GOST28147WrapEngine {
    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        KeyParameter keyParameter;
        CipherParameters cipherParameters;
        if (param instanceof ParametersWithRandom) {
            cipherParameters = (ParametersWithRandom)param;
            param = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        cipherParameters = (ParametersWithUKM)param;
        byte[] byArray = null;
        if (((ParametersWithUKM)cipherParameters).getParameters() instanceof ParametersWithSBox) {
            keyParameter = (KeyParameter)((ParametersWithSBox)((ParametersWithUKM)cipherParameters).getParameters()).getParameters();
            byArray = ((ParametersWithSBox)((ParametersWithUKM)cipherParameters).getParameters()).getSBox();
        } else {
            keyParameter = (KeyParameter)((ParametersWithUKM)cipherParameters).getParameters();
        }
        keyParameter = new KeyParameter(CryptoProWrapEngine.a(keyParameter.getKey(), ((ParametersWithUKM)cipherParameters).getUKM(), byArray));
        if (byArray != null) {
            super.init(forWrapping, new ParametersWithUKM(new ParametersWithSBox(keyParameter, byArray), ((ParametersWithUKM)cipherParameters).getUKM()));
        } else {
            super.init(forWrapping, new ParametersWithUKM(keyParameter, ((ParametersWithUKM)cipherParameters).getUKM()));
        }
    }

    private static byte[] a(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i2 = 0; i2 != 8; ++i2) {
            int n2 = 0;
            int n3 = 0;
            for (int i3 = 0; i3 != 8; ++i3) {
                int n4 = Pack.littleEndianToInt(byArray, i3 * 4);
                if (CryptoProWrapEngine.a(byArray2[i2], i3)) {
                    n2 += n4;
                    continue;
                }
                n3 += n4;
            }
            byte[] byArray4 = new byte[8];
            Pack.intToLittleEndian(n2, byArray4, 0);
            Pack.intToLittleEndian(n3, byArray4, 4);
            GCFBBlockCipher gCFBBlockCipher = new GCFBBlockCipher(new GOST28147Engine());
            gCFBBlockCipher.init(true, new ParametersWithIV(new ParametersWithSBox(new KeyParameter(byArray), byArray3), byArray4));
            gCFBBlockCipher.processBlock(byArray, 0, byArray, 0);
            gCFBBlockCipher.processBlock(byArray, 8, byArray, 8);
            gCFBBlockCipher.processBlock(byArray, 16, byArray, 16);
            gCFBBlockCipher.processBlock(byArray, 24, byArray, 24);
        }
        return byArray;
    }

    private static boolean a(byte by, int n2) {
        return (by & 1 << n2) != 0;
    }
}

