/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.Wrapper;
import com.enterprisedt.bouncycastle.crypto.engines.GOST28147Engine;
import com.enterprisedt.bouncycastle.crypto.macs.GOST28147Mac;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithSBox;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithUKM;
import com.enterprisedt.bouncycastle.util.Arrays;

public class GOST28147WrapEngine
implements Wrapper {
    private GOST28147Engine a = new GOST28147Engine();
    private GOST28147Mac b = new GOST28147Mac();

    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        CipherParameters cipherParameters;
        if (param instanceof ParametersWithRandom) {
            cipherParameters = (ParametersWithRandom)param;
            param = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        cipherParameters = (ParametersWithUKM)param;
        this.a.init(forWrapping, ((ParametersWithUKM)cipherParameters).getParameters());
        KeyParameter keyParameter = ((ParametersWithUKM)cipherParameters).getParameters() instanceof ParametersWithSBox ? (KeyParameter)((ParametersWithSBox)((ParametersWithUKM)cipherParameters).getParameters()).getParameters() : (KeyParameter)((ParametersWithUKM)cipherParameters).getParameters();
        this.b.init(new ParametersWithIV(keyParameter, ((ParametersWithUKM)cipherParameters).getUKM()));
    }

    @Override
    public String getAlgorithmName() {
        return "GOST28147Wrap";
    }

    @Override
    public byte[] wrap(byte[] input, int inOff, int inLen) {
        this.b.update(input, inOff, inLen);
        byte[] byArray = new byte[inLen + this.b.getMacSize()];
        this.a.processBlock(input, inOff, byArray, 0);
        this.a.processBlock(input, inOff + 8, byArray, 8);
        this.a.processBlock(input, inOff + 16, byArray, 16);
        this.a.processBlock(input, inOff + 24, byArray, 24);
        this.b.doFinal(byArray, inLen);
        return byArray;
    }

    @Override
    public byte[] unwrap(byte[] input, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] byArray = new byte[inLen - this.b.getMacSize()];
        this.a.processBlock(input, inOff, byArray, 0);
        this.a.processBlock(input, inOff + 8, byArray, 8);
        this.a.processBlock(input, inOff + 16, byArray, 16);
        this.a.processBlock(input, inOff + 24, byArray, 24);
        byte[] byArray2 = new byte[this.b.getMacSize()];
        this.b.update(byArray, 0, byArray.length);
        this.b.doFinal(byArray2, 0);
        byte[] byArray3 = new byte[this.b.getMacSize()];
        System.arraycopy(input, inOff + inLen - 4, byArray3, 0, this.b.getMacSize());
        if (!Arrays.constantTimeAreEqual(byArray2, byArray3)) {
            throw new IllegalStateException("mac mismatch");
        }
        return byArray;
    }
}

