/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.StreamCipher;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;

public class RC4Engine
implements StreamCipher {
    private byte[] a = null;
    private int b = 0;
    private int c = 0;
    private byte[] d = null;

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        if (params instanceof KeyParameter) {
            this.d = ((KeyParameter)params).getKey();
            this.a(this.d);
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to RC4 init - " + params.getClass().getName());
    }

    @Override
    public String getAlgorithmName() {
        return "RC4";
    }

    @Override
    public byte returnByte(byte in) {
        this.b = this.b + 1 & 0xFF;
        this.c = this.a[this.b] + this.c & 0xFF;
        byte by = this.a[this.b];
        this.a[this.b] = this.a[this.c];
        this.a[this.c] = by;
        return (byte)(in ^ this.a[this.a[this.b] + this.a[this.c] & 0xFF]);
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) {
        if (inOff + len > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + len > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < len; ++i2) {
            this.b = this.b + 1 & 0xFF;
            this.c = this.a[this.b] + this.c & 0xFF;
            byte by = this.a[this.b];
            this.a[this.b] = this.a[this.c];
            this.a[this.c] = by;
            out[i2 + outOff] = (byte)(in[i2 + inOff] ^ this.a[this.a[this.b] + this.a[this.c] & 0xFF]);
        }
        return len;
    }

    @Override
    public void reset() {
        this.a(this.d);
    }

    private void a(byte[] byArray) {
        int n2;
        this.d = byArray;
        this.b = 0;
        this.c = 0;
        if (this.a == null) {
            this.a = new byte[256];
        }
        for (n2 = 0; n2 < 256; ++n2) {
            this.a[n2] = (byte)n2;
        }
        n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            n3 = (byArray[n2] & 0xFF) + this.a[i2] + n3 & 0xFF;
            byte by = this.a[i2];
            this.a[i2] = this.a[n3];
            this.a[n3] = by;
            n2 = (n2 + 1) % byArray.length;
        }
    }
}

