/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;

public class RC6Engine
implements BlockCipher {
    private int[] a = null;
    private boolean b;

    @Override
    public String getAlgorithmName() {
        return "RC6";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to RC6 init - " + params.getClass().getName());
        }
        KeyParameter keyParameter = (KeyParameter)params;
        this.b = forEncryption;
        this.a(keyParameter.getKey());
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        int n2 = this.getBlockSize();
        if (this.a == null) {
            throw new IllegalStateException("RC6 engine not initialised");
        }
        if (inOff + n2 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + n2 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        return this.b ? this.a(in, inOff, out, outOff) : this.b(in, inOff, out, outOff);
    }

    @Override
    public void reset() {
    }

    private void a(byte[] byArray) {
        int n2;
        int n3 = (byArray.length + 3) / 4;
        if (n3 == 0) {
            n3 = 1;
        }
        int[] nArray = new int[(byArray.length + 4 - 1) / 4];
        for (n2 = byArray.length - 1; n2 >= 0; --n2) {
            nArray[n2 / 4] = (nArray[n2 / 4] << 8) + (byArray[n2] & 0xFF);
        }
        this.a = new int[44];
        this.a[0] = -1209970333;
        for (n2 = 1; n2 < this.a.length; ++n2) {
            this.a[n2] = this.a[n2 - 1] + -1640531527;
        }
        n2 = nArray.length > this.a.length ? 3 * nArray.length : 3 * this.a.length;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n4 = this.a[n6] = this.a(this.a[n6] + n4 + n5, 3);
            n5 = nArray[n7] = this.a(nArray[n7] + n4 + n5, n4 + n5);
            n6 = (n6 + 1) % this.a.length;
            n7 = (n7 + 1) % nArray.length;
        }
    }

    private int a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = this.a(byArray, n2);
        int n5 = this.a(byArray, n2 + 4);
        int n6 = this.a(byArray, n2 + 8);
        int n7 = this.a(byArray, n2 + 12);
        n5 += this.a[0];
        n7 += this.a[1];
        for (int i2 = 1; i2 <= 20; ++i2) {
            int n8 = 0;
            int n9 = 0;
            n8 = n5 * (2 * n5 + 1);
            n8 = this.a(n8, 5);
            n9 = n7 * (2 * n7 + 1);
            n9 = this.a(n9, 5);
            n4 ^= n8;
            n4 = this.a(n4, n9);
            n6 ^= n9;
            n6 = this.a(n6, n8);
            int n10 = n4 += this.a[2 * i2];
            n4 = n5;
            n5 = n6 += this.a[2 * i2 + 1];
            n6 = n7;
            n7 = n10;
        }
        this.a(n4 += this.a[42], byArray2, n3);
        this.a(n5, byArray2, n3 + 4);
        this.a(n6 += this.a[43], byArray2, n3 + 8);
        this.a(n7, byArray2, n3 + 12);
        return 16;
    }

    private int b(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = this.a(byArray, n2);
        int n5 = this.a(byArray, n2 + 4);
        int n6 = this.a(byArray, n2 + 8);
        int n7 = this.a(byArray, n2 + 12);
        n6 -= this.a[43];
        n4 -= this.a[42];
        for (int i2 = 20; i2 >= 1; --i2) {
            int n8 = 0;
            int n9 = 0;
            int n10 = n7;
            n7 = n6;
            n6 = n5;
            n5 = n4;
            n4 = n10;
            n8 = n5 * (2 * n5 + 1);
            n8 = this.a(n8, 5);
            n9 = n7 * (2 * n7 + 1);
            n9 = this.a(n9, 5);
            n6 -= this.a[2 * i2 + 1];
            n6 = this.b(n6, n8);
            n6 ^= n9;
            n4 -= this.a[2 * i2];
            n4 = this.b(n4, n9);
            n4 ^= n8;
        }
        this.a(n4, byArray2, n3);
        this.a(n5 -= this.a[0], byArray2, n3 + 4);
        this.a(n6, byArray2, n3 + 8);
        this.a(n7 -= this.a[1], byArray2, n3 + 12);
        return 16;
    }

    private int a(int n2, int n3) {
        return n2 << n3 | n2 >>> -n3;
    }

    private int b(int n2, int n3) {
        return n2 >>> n3 | n2 << -n3;
    }

    private int a(byte[] byArray, int n2) {
        int n3 = 0;
        for (int i2 = 3; i2 >= 0; --i2) {
            n3 = (n3 << 8) + (byArray[i2 + n2] & 0xFF);
        }
        return n3;
    }

    private void a(int n2, byte[] byArray, int n3) {
        for (int i2 = 0; i2 < 4; ++i2) {
            byArray[i2 + n3] = (byte)n2;
            n2 >>>= 8;
        }
    }
}

