/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.Wrapper;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.util.Arrays;

public class RFC3394WrapEngine
implements Wrapper {
    private BlockCipher a;
    private boolean b;
    private KeyParameter c;
    private boolean d;
    private byte[] e = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};

    public RFC3394WrapEngine(BlockCipher engine) {
        this(engine, false);
    }

    public RFC3394WrapEngine(BlockCipher engine, boolean useReverseDirection) {
        this.a = engine;
        this.b = !useReverseDirection;
    }

    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        this.d = forWrapping;
        if (param instanceof ParametersWithRandom) {
            param = ((ParametersWithRandom)param).getParameters();
        }
        if (param instanceof KeyParameter) {
            this.c = (KeyParameter)param;
        } else if (param instanceof ParametersWithIV) {
            this.e = ((ParametersWithIV)param).getIV();
            this.c = (KeyParameter)((ParametersWithIV)param).getParameters();
            if (this.e.length != 8) {
                throw new IllegalArgumentException("IV not equal to 8");
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getAlgorithmName();
    }

    @Override
    public byte[] wrap(byte[] in, int inOff, int inLen) {
        if (!this.d) {
            throw new IllegalStateException("not set for wrapping");
        }
        int n2 = inLen / 8;
        if (n2 * 8 != inLen) {
            throw new DataLengthException("wrap data must be a multiple of 8 bytes");
        }
        byte[] byArray = new byte[inLen + this.e.length];
        byte[] byArray2 = new byte[8 + this.e.length];
        System.arraycopy(this.e, 0, byArray, 0, this.e.length);
        System.arraycopy(in, inOff, byArray, this.e.length, inLen);
        this.a.init(this.b, this.c);
        for (int i2 = 0; i2 != 6; ++i2) {
            for (int i3 = 1; i3 <= n2; ++i3) {
                System.arraycopy(byArray, 0, byArray2, 0, this.e.length);
                System.arraycopy(byArray, 8 * i3, byArray2, this.e.length, 8);
                this.a.processBlock(byArray2, 0, byArray2, 0);
                int n3 = n2 * i2 + i3;
                int n4 = 1;
                while (n3 != 0) {
                    byte by = (byte)n3;
                    int n5 = this.e.length - n4;
                    byArray2[n5] = (byte)(byArray2[n5] ^ by);
                    n3 >>>= 8;
                    ++n4;
                }
                System.arraycopy(byArray2, 0, byArray, 0, 8);
                System.arraycopy(byArray2, 8, byArray, 8 * i3, 8);
            }
        }
        return byArray;
    }

    @Override
    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.d) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n2 = inLen / 8;
        if (n2 * 8 != inLen) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        byte[] byArray = new byte[inLen - this.e.length];
        byte[] byArray2 = new byte[this.e.length];
        byte[] byArray3 = new byte[8 + this.e.length];
        System.arraycopy(in, inOff, byArray2, 0, this.e.length);
        System.arraycopy(in, inOff + this.e.length, byArray, 0, inLen - this.e.length);
        this.a.init(!this.b, this.c);
        --n2;
        for (int i2 = 5; i2 >= 0; --i2) {
            for (int i3 = n2; i3 >= 1; --i3) {
                System.arraycopy(byArray2, 0, byArray3, 0, this.e.length);
                System.arraycopy(byArray, 8 * (i3 - 1), byArray3, this.e.length, 8);
                int n3 = n2 * i2 + i3;
                int n4 = 1;
                while (n3 != 0) {
                    byte by = (byte)n3;
                    int n5 = this.e.length - n4;
                    byArray3[n5] = (byte)(byArray3[n5] ^ by);
                    n3 >>>= 8;
                    ++n4;
                }
                this.a.processBlock(byArray3, 0, byArray3, 0);
                System.arraycopy(byArray3, 0, byArray2, 0, 8);
                System.arraycopy(byArray3, 8, byArray, 8 * (i3 - 1), 8);
            }
        }
        if (!Arrays.constantTimeAreEqual(byArray2, this.e)) {
            throw new InvalidCipherTextException("checksum failed");
        }
        return byArray;
    }
}

