/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.Wrapper;
import com.enterprisedt.bouncycastle.crypto.engines.RFC3394WrapEngine;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;

public class RFC5649WrapEngine
implements Wrapper {
    private BlockCipher a;
    private KeyParameter b;
    private boolean c;
    private byte[] d = new byte[]{-90, 89, 89, -90};
    private byte[] e = this.d;
    private byte[] f = null;

    public RFC5649WrapEngine(BlockCipher engine) {
        this.a = engine;
    }

    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        this.c = forWrapping;
        if (param instanceof ParametersWithRandom) {
            param = ((ParametersWithRandom)param).getParameters();
        }
        if (param instanceof KeyParameter) {
            this.b = (KeyParameter)param;
            this.e = this.d;
        } else if (param instanceof ParametersWithIV) {
            this.e = ((ParametersWithIV)param).getIV();
            this.b = (KeyParameter)((ParametersWithIV)param).getParameters();
            if (this.e.length != 4) {
                throw new IllegalArgumentException("IV length not equal to 4");
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getAlgorithmName();
    }

    private byte[] a(byte[] byArray) {
        int n2 = byArray.length;
        int n3 = (8 - n2 % 8) % 8;
        byte[] byArray2 = new byte[n2 + n3];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        if (n3 != 0) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray3, 0, byArray2, n2, n3);
        }
        return byArray2;
    }

    @Override
    public byte[] wrap(byte[] in, int inOff, int inLen) {
        if (!this.c) {
            throw new IllegalStateException("not set for wrapping");
        }
        byte[] byArray = new byte[8];
        byte[] byArray2 = Pack.intToBigEndian(inLen);
        System.arraycopy(this.e, 0, byArray, 0, this.e.length);
        System.arraycopy(byArray2, 0, byArray, this.e.length, byArray2.length);
        byte[] byArray3 = new byte[inLen];
        System.arraycopy(in, inOff, byArray3, 0, inLen);
        byte[] byArray4 = this.a(byArray3);
        if (byArray4.length == 8) {
            byte[] byArray5 = new byte[byArray4.length + byArray.length];
            System.arraycopy(byArray, 0, byArray5, 0, byArray.length);
            System.arraycopy(byArray4, 0, byArray5, byArray.length, byArray4.length);
            this.a.init(true, this.b);
            for (int i2 = 0; i2 < byArray5.length; i2 += this.a.getBlockSize()) {
                this.a.processBlock(byArray5, i2, byArray5, i2);
            }
            return byArray5;
        }
        RFC3394WrapEngine rFC3394WrapEngine = new RFC3394WrapEngine(this.a);
        ParametersWithIV parametersWithIV = new ParametersWithIV(this.b, byArray);
        rFC3394WrapEngine.init(true, parametersWithIV);
        return rFC3394WrapEngine.wrap(byArray4, 0, byArray4.length);
    }

    @Override
    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int n2;
        int n3;
        int n4;
        byte[] byArray;
        if (this.c) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n5 = inLen / 8;
        if (n5 * 8 != inLen) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        if (n5 == 1) {
            throw new InvalidCipherTextException("unwrap data must be at least 16 bytes");
        }
        byte[] byArray2 = new byte[inLen];
        System.arraycopy(in, inOff, byArray2, 0, inLen);
        byte[] byArray3 = new byte[inLen];
        if (n5 == 2) {
            this.a.init(false, this.b);
            for (int i2 = 0; i2 < byArray2.length; i2 += this.a.getBlockSize()) {
                this.a.processBlock(byArray2, i2, byArray3, i2);
            }
            this.f = new byte[8];
            System.arraycopy(byArray3, 0, this.f, 0, this.f.length);
            byArray = new byte[byArray3.length - this.f.length];
            System.arraycopy(byArray3, this.f.length, byArray, 0, byArray.length);
        } else {
            byArray = byArray3 = this.a(in, inOff, inLen);
        }
        byte[] byArray4 = new byte[4];
        byte[] byArray5 = new byte[4];
        System.arraycopy(this.f, 0, byArray4, 0, byArray4.length);
        System.arraycopy(this.f, byArray4.length, byArray5, 0, byArray5.length);
        int n6 = Pack.bigEndianToInt(byArray5, 0);
        boolean bl = true;
        if (!Arrays.constantTimeAreEqual(byArray4, this.e)) {
            bl = false;
        }
        if (n6 <= (n4 = (n3 = byArray.length) - 8)) {
            bl = false;
        }
        if (n6 > n3) {
            bl = false;
        }
        if ((n2 = n3 - n6) >= byArray.length) {
            bl = false;
            n2 = byArray.length;
        }
        byte[] byArray6 = new byte[n2];
        byte[] byArray7 = new byte[n2];
        System.arraycopy(byArray, byArray.length - n2, byArray7, 0, n2);
        if (!Arrays.constantTimeAreEqual(byArray7, byArray6)) {
            bl = false;
        }
        if (!bl) {
            throw new InvalidCipherTextException("checksum failed");
        }
        byte[] byArray8 = new byte[n6];
        System.arraycopy(byArray, 0, byArray8, 0, byArray8.length);
        return byArray8;
    }

    private byte[] a(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[n3 - byArray2.length];
        byte[] byArray4 = new byte[byArray2.length];
        byte[] byArray5 = new byte[8 + byArray2.length];
        System.arraycopy(byArray, n2, byArray4, 0, byArray2.length);
        System.arraycopy(byArray, n2 + byArray2.length, byArray3, 0, n3 - byArray2.length);
        this.a.init(false, this.b);
        int n4 = n3 / 8;
        --n4;
        for (int i2 = 5; i2 >= 0; --i2) {
            for (int i3 = n4; i3 >= 1; --i3) {
                System.arraycopy(byArray4, 0, byArray5, 0, byArray2.length);
                System.arraycopy(byArray3, 8 * (i3 - 1), byArray5, byArray2.length, 8);
                int n5 = n4 * i2 + i3;
                int n6 = 1;
                while (n5 != 0) {
                    byte by = (byte)n5;
                    int n7 = byArray2.length - n6;
                    byArray5[n7] = (byte)(byArray5[n7] ^ by);
                    n5 >>>= 8;
                    ++n6;
                }
                this.a.processBlock(byArray5, 0, byArray5, 0);
                System.arraycopy(byArray5, 0, byArray4, 0, 8);
                System.arraycopy(byArray5, 8, byArray3, 8 * (i3 - 1), 8);
            }
        }
        this.f = byArray4;
        return byArray3;
    }
}

