/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.engines;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.util.Pack;

public class SM4Engine
implements BlockCipher {
    private static final byte[] a = new byte[]{-42, -112, -23, -2, -52, -31, 61, -73, 22, -74, 20, -62, 40, -5, 44, 5, 43, 103, -102, 118, 42, -66, 4, -61, -86, 68, 19, 38, 73, -122, 6, -103, -100, 66, 80, -12, -111, -17, -104, 122, 51, 84, 11, 67, -19, -49, -84, 98, -28, -77, 28, -87, -55, 8, -24, -107, -128, -33, -108, -6, 117, -113, 63, -90, 71, 7, -89, -4, -13, 115, 23, -70, -125, 89, 60, 25, -26, -123, 79, -88, 104, 107, -127, -78, 113, 100, -38, -117, -8, -21, 15, 75, 112, 86, -99, 53, 30, 36, 14, 94, 99, 88, -47, -94, 37, 34, 124, 59, 1, 33, 120, -121, -44, 0, 70, 87, -97, -45, 39, 82, 76, 54, 2, -25, -96, -60, -56, -98, -22, -65, -118, -46, 64, -57, 56, -75, -93, -9, -14, -50, -7, 97, 21, -95, -32, -82, 93, -92, -101, 52, 26, 85, -83, -109, 50, 48, -11, -116, -79, -29, 29, -10, -30, 46, -126, 102, -54, 96, -64, 41, 35, -85, 13, 83, 78, 111, -43, -37, 55, 69, -34, -3, -114, 47, 3, -1, 106, 114, 109, 108, 91, 81, -115, 27, -81, -110, -69, -35, -68, 127, 17, -39, 92, 65, 31, 16, 90, -40, 10, -63, 49, -120, -91, -51, 123, -67, 45, 116, -48, 18, -72, -27, -76, -80, -119, 105, -105, 74, 12, -106, 119, 126, 101, -71, -15, 9, -59, 110, -58, -124, 24, -16, 125, -20, 58, -36, 77, 32, 121, -18, 95, 62, -41, -53, 57, 72};
    private static final int[] b = new int[]{462357, 472066609, 943670861, 1415275113, 1886879365, -1936483679, -1464879427, -993275175, -521670923, -66909679, 404694573, 876298825, 1347903077, 1819507329, -2003855715, -1532251463, -1060647211, -589042959, -117504499, 337322537, 808926789, 1280531041, 1752135293, -2071227751, -1599623499, -1128019247, -656414995, -184876535, 269950501, 741554753, 1213159005, 1684763257};
    private static final int[] c = new int[]{-1548633402, 1453994832, 1736282519, -1301273892};
    private final int[] d = new int[4];
    private int[] e;

    private int a(int n2, int n3) {
        return n2 << n3 | n2 >>> -n3;
    }

    private int a(int n2) {
        int n3 = a[n2 >> 24 & 0xFF] & 0xFF;
        int n4 = a[n2 >> 16 & 0xFF] & 0xFF;
        int n5 = a[n2 >> 8 & 0xFF] & 0xFF;
        int n6 = a[n2 & 0xFF] & 0xFF;
        return n3 << 24 | n4 << 16 | n5 << 8 | n6;
    }

    private int b(int n2) {
        return n2 ^ this.a(n2, 13) ^ this.a(n2, 23);
    }

    private int c(int n2) {
        return this.b(this.a(n2));
    }

    private int[] a(boolean bl, byte[] byArray) {
        int[] nArray = new int[32];
        int[] nArray2 = new int[]{Pack.bigEndianToInt(byArray, 0), Pack.bigEndianToInt(byArray, 4), Pack.bigEndianToInt(byArray, 8), Pack.bigEndianToInt(byArray, 12)};
        int[] nArray3 = new int[]{nArray2[0] ^ c[0], nArray2[1] ^ c[1], nArray2[2] ^ c[2], nArray2[3] ^ c[3]};
        if (bl) {
            nArray[0] = nArray3[0] ^ this.c(nArray3[1] ^ nArray3[2] ^ nArray3[3] ^ b[0]);
            nArray[1] = nArray3[1] ^ this.c(nArray3[2] ^ nArray3[3] ^ nArray[0] ^ b[1]);
            nArray[2] = nArray3[2] ^ this.c(nArray3[3] ^ nArray[0] ^ nArray[1] ^ b[2]);
            nArray[3] = nArray3[3] ^ this.c(nArray[0] ^ nArray[1] ^ nArray[2] ^ b[3]);
            for (int i2 = 4; i2 < 32; ++i2) {
                nArray[i2] = nArray[i2 - 4] ^ this.c(nArray[i2 - 3] ^ nArray[i2 - 2] ^ nArray[i2 - 1] ^ b[i2]);
            }
        } else {
            nArray[31] = nArray3[0] ^ this.c(nArray3[1] ^ nArray3[2] ^ nArray3[3] ^ b[0]);
            nArray[30] = nArray3[1] ^ this.c(nArray3[2] ^ nArray3[3] ^ nArray[31] ^ b[1]);
            nArray[29] = nArray3[2] ^ this.c(nArray3[3] ^ nArray[31] ^ nArray[30] ^ b[2]);
            nArray[28] = nArray3[3] ^ this.c(nArray[31] ^ nArray[30] ^ nArray[29] ^ b[3]);
            for (int i3 = 27; i3 >= 0; --i3) {
                nArray[i3] = nArray[i3 + 4] ^ this.c(nArray[i3 + 3] ^ nArray[i3 + 2] ^ nArray[i3 + 1] ^ b[31 - i3]);
            }
        }
        return nArray;
    }

    private int d(int n2) {
        int n3 = n2 ^ this.a(n2, 2) ^ this.a(n2, 10) ^ this.a(n2, 18) ^ this.a(n2, 24);
        return n3;
    }

    private int e(int n2) {
        return this.d(this.a(n2));
    }

    private void a(int[] nArray, int n2) {
        int n3 = n2;
        int n4 = n2 + 1;
        int n5 = n2 + 2;
        int n6 = n2 + 3;
        nArray[n3] = nArray[n3] ^ nArray[n6];
        nArray[n6] = nArray[n3] ^ nArray[n6];
        nArray[n3] = nArray[n3] ^ nArray[n6];
        nArray[n4] = nArray[n4] ^ nArray[n5];
        nArray[n5] = nArray[n4] ^ nArray[n5];
        nArray[n4] = nArray[n4] ^ nArray[n5];
    }

    private int b(int[] nArray, int n2) {
        return nArray[0] ^ this.e(nArray[1] ^ nArray[2] ^ nArray[3] ^ n2);
    }

    private int c(int[] nArray, int n2) {
        return nArray[1] ^ this.e(nArray[2] ^ nArray[3] ^ nArray[0] ^ n2);
    }

    private int d(int[] nArray, int n2) {
        return nArray[2] ^ this.e(nArray[3] ^ nArray[0] ^ nArray[1] ^ n2);
    }

    private int e(int[] nArray, int n2) {
        return nArray[3] ^ this.e(nArray[0] ^ nArray[1] ^ nArray[2] ^ n2);
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        byte[] byArray;
        if (params instanceof KeyParameter) {
            byArray = ((KeyParameter)params).getKey();
            if (byArray.length != 16) {
                throw new IllegalArgumentException("SM4 requires a 128 bit key");
            }
        } else {
            throw new IllegalArgumentException("invalid parameter passed to SM4 init - " + params.getClass().getName());
        }
        this.e = this.a(forEncryption, byArray);
    }

    @Override
    public String getAlgorithmName() {
        return "SM4";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this.e == null) {
            throw new IllegalStateException("SM4 not initialised");
        }
        if (inOff + 16 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        this.d[0] = Pack.bigEndianToInt(in, inOff);
        this.d[1] = Pack.bigEndianToInt(in, inOff + 4);
        this.d[2] = Pack.bigEndianToInt(in, inOff + 8);
        this.d[3] = Pack.bigEndianToInt(in, inOff + 12);
        for (int i2 = 0; i2 < 32; i2 += 4) {
            this.d[0] = this.b(this.d, this.e[i2]);
            this.d[1] = this.c(this.d, this.e[i2 + 1]);
            this.d[2] = this.d(this.d, this.e[i2 + 2]);
            this.d[3] = this.e(this.d, this.e[i2 + 3]);
        }
        this.a(this.d, 0);
        Pack.intToBigEndian(this.d[0], out, outOff);
        Pack.intToBigEndian(this.d[1], out, outOff + 4);
        Pack.intToBigEndian(this.d[2], out, outOff + 8);
        Pack.intToBigEndian(this.d[3], out, outOff + 12);
        return 16;
    }

    @Override
    public void reset() {
    }
}

