/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.generators;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA1Digest;
import com.enterprisedt.bouncycastle.crypto.params.DSAParameterGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.params.DSAParameters;
import com.enterprisedt.bouncycastle.crypto.params.DSAValidationParameters;
import com.enterprisedt.bouncycastle.crypto.util.DigestFactory;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAParametersGenerator {
    private static final BigInteger a = BigInteger.valueOf(0L);
    private static final BigInteger b = BigInteger.valueOf(1L);
    private static final BigInteger c = BigInteger.valueOf(2L);
    private Digest d;
    private int e;
    private int f;
    private int g;
    private int h;
    private SecureRandom i;
    private boolean j;
    private int k;

    public DSAParametersGenerator() {
        this(DigestFactory.createSHA1());
    }

    public DSAParametersGenerator(Digest digest) {
        this.d = digest;
    }

    public void init(int size, int certainty, SecureRandom random) {
        this.e = size;
        this.f = DSAParametersGenerator.a(size);
        this.g = certainty;
        this.h = Math.max(DSAParametersGenerator.b(this.e), (certainty + 1) / 2);
        this.i = random;
        this.j = false;
        this.k = -1;
    }

    public void init(DSAParameterGenerationParameters params) {
        int n2 = params.getL();
        int n3 = params.getN();
        if (n2 < 1024 || n2 > 3072 || n2 % 1024 != 0) {
            throw new IllegalArgumentException("L values must be between 1024 and 3072 and a multiple of 1024");
        }
        if (n2 == 1024 && n3 != 160) {
            throw new IllegalArgumentException("N must be 160 for L = 1024");
        }
        if (n2 == 2048 && n3 != 224 && n3 != 256) {
            throw new IllegalArgumentException("N must be 224 or 256 for L = 2048");
        }
        if (n2 == 3072 && n3 != 256) {
            throw new IllegalArgumentException("N must be 256 for L = 3072");
        }
        if (this.d.getDigestSize() * 8 < n3) {
            throw new IllegalStateException("Digest output size too small for value of N");
        }
        this.e = n2;
        this.f = n3;
        this.g = params.getCertainty();
        this.h = Math.max(DSAParametersGenerator.b(n2), (this.g + 1) / 2);
        this.i = params.getRandom();
        this.j = true;
        this.k = params.getUsageIndex();
    }

    public DSAParameters generateParameters() {
        return this.j ? this.b() : this.a();
    }

    /*
     * Unable to fully structure code
     */
    private DSAParameters a() {
        var1_1 = new byte[20];
        var2_2 = new byte[20];
        var3_3 = new byte[20];
        var4_4 = new byte[20];
        var5_5 = (this.e - 1) / 160;
        var6_6 = new byte[this.e / 8];
        if (!(this.d instanceof SHA1Digest)) {
            throw new IllegalStateException("can only use SHA-1 for generating FIPS 186-2 parameters");
        }
        block0: while (true) {
            this.i.nextBytes(var1_1);
            DSAParametersGenerator.a(this.d, var1_1, var2_2, 0);
            System.arraycopy(var1_1, 0, var3_3, 0, var1_1.length);
            DSAParametersGenerator.a(var3_3);
            DSAParametersGenerator.a(this.d, var3_3, var3_3, 0);
            for (var7_8 = 0; var7_8 != var4_4.length; ++var7_8) {
                var4_4[var7_8] = (byte)(var2_2[var7_8] ^ var3_3[var7_8]);
            }
            var4_4[0] = (byte)(var4_4[0] | -128);
            var4_4[19] = (byte)(var4_4[19] | 1);
            var7_7 = new BigInteger(1, var4_4);
            if (!this.a(var7_7)) continue;
            var8_9 = Arrays.clone(var1_1);
            DSAParametersGenerator.a(var8_9);
            var9_10 = 0;
            while (true) {
                if (var9_10 < 4096) ** break;
                continue block0;
                for (var10_12 = 1; var10_12 <= var5_5; ++var10_12) {
                    DSAParametersGenerator.a(var8_9);
                    DSAParametersGenerator.a(this.d, var8_9, var6_6, var6_6.length - var10_12 * var2_2.length);
                }
                var10_12 = var6_6.length - var5_5 * var2_2.length;
                DSAParametersGenerator.a(var8_9);
                DSAParametersGenerator.a(this.d, var8_9, var2_2, 0);
                System.arraycopy(var2_2, var2_2.length - var10_12, var6_6, 0, var10_12);
                var6_6[0] = (byte)(var6_6[0] | -128);
                var10_11 = new BigInteger(1, var6_6);
                var11_13 = var10_11.mod(var7_7.shiftLeft(1));
                var12_14 = var10_11.subtract(var11_13.subtract(DSAParametersGenerator.b));
                if (var12_14.bitLength() == this.e && this.a(var12_14)) {
                    var13_15 = DSAParametersGenerator.a(var12_14, var7_7, this.i);
                    return new DSAParameters(var12_14, var7_7, var13_15, new DSAValidationParameters(var1_1, var9_10));
                }
                ++var9_10;
            }
            break;
        }
    }

    private static BigInteger a(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5 = bigInteger.subtract(b).divide(bigInteger2);
        BigInteger bigInteger6 = bigInteger.subtract(c);
        while ((bigInteger4 = (bigInteger3 = BigIntegers.createRandomInRange(c, bigInteger6, secureRandom)).modPow(bigInteger5, bigInteger)).bitLength() <= 1) {
        }
        return bigInteger4;
    }

    /*
     * Unable to fully structure code
     */
    private DSAParameters b() {
        var1_1 = this.d;
        var2_2 = var1_1.getDigestSize() * 8;
        var3_3 = this.f;
        var4_4 = new byte[var3_3 / 8];
        var5_5 = (this.e - 1) / var2_2;
        var6_6 = (this.e - 1) % var2_2;
        var7_7 = new byte[this.e / 8];
        var8_8 = new byte[var1_1.getDigestSize()];
        block0: while (true) {
            this.i.nextBytes(var4_4);
            DSAParametersGenerator.a(var1_1, var4_4, var8_8, 0);
            var9_9 = new BigInteger(1, var8_8).mod(DSAParametersGenerator.b.shiftLeft(this.f - 1));
            var10_10 = var9_9.setBit(0).setBit(this.f - 1);
            if (!this.a(var10_10)) continue;
            var11_11 = Arrays.clone(var4_4);
            var12_12 = 4 * this.e;
            var13_13 = 0;
            while (true) {
                if (var13_13 < var12_12) ** break;
                continue block0;
                for (var14_15 = 1; var14_15 <= var5_5; ++var14_15) {
                    DSAParametersGenerator.a(var11_11);
                    DSAParametersGenerator.a(var1_1, var11_11, var7_7, var7_7.length - var14_15 * var8_8.length);
                }
                var14_15 = var7_7.length - var5_5 * var8_8.length;
                DSAParametersGenerator.a(var11_11);
                DSAParametersGenerator.a(var1_1, var11_11, var8_8, 0);
                System.arraycopy(var8_8, var8_8.length - var14_15, var7_7, 0, var14_15);
                var7_7[0] = (byte)(var7_7[0] | -128);
                var14_14 = new BigInteger(1, var7_7);
                var15_16 = var14_14.mod(var10_10.shiftLeft(1));
                var16_17 = var14_14.subtract(var15_16.subtract(DSAParametersGenerator.b));
                if (var16_17.bitLength() == this.e && this.a(var16_17)) {
                    if (this.k >= 0 && (var17_18 = DSAParametersGenerator.a(var1_1, var16_17, var10_10, var4_4, this.k)) != null) {
                        return new DSAParameters(var16_17, var10_10, var17_18, new DSAValidationParameters(var4_4, var13_13, this.k));
                    }
                    var17_18 = DSAParametersGenerator.b(var16_17, var10_10, this.i);
                    return new DSAParameters(var16_17, var10_10, var17_18, new DSAValidationParameters(var4_4, var13_13));
                }
                ++var13_13;
            }
            break;
        }
    }

    private boolean a(BigInteger bigInteger) {
        return bigInteger.isProbablePrime(this.g);
    }

    private static BigInteger b(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        return DSAParametersGenerator.a(bigInteger, bigInteger2, secureRandom);
    }

    private static BigInteger a(Digest digest, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n2) {
        BigInteger bigInteger3 = bigInteger.subtract(b).divide(bigInteger2);
        byte[] byArray2 = Hex.decode("6767656E");
        byte[] byArray3 = new byte[byArray.length + byArray2.length + 1 + 2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        byArray3[byArray3.length - 3] = (byte)n2;
        byte[] byArray4 = new byte[digest.getDigestSize()];
        for (int i2 = 1; i2 < 65536; ++i2) {
            DSAParametersGenerator.a(byArray3);
            DSAParametersGenerator.a(digest, byArray3, byArray4, 0);
            BigInteger bigInteger4 = new BigInteger(1, byArray4);
            BigInteger bigInteger5 = bigInteger4.modPow(bigInteger3, bigInteger);
            if (bigInteger5.compareTo(c) < 0) continue;
            return bigInteger5;
        }
        return null;
    }

    private static void a(Digest digest, byte[] byArray, byte[] byArray2, int n2) {
        digest.update(byArray, 0, byArray.length);
        digest.doFinal(byArray2, n2);
    }

    private static int a(int n2) {
        return n2 > 1024 ? 256 : 160;
    }

    private static int b(int n2) {
        return n2 <= 1024 ? 40 : 48 + 8 * ((n2 - 1) / 1024);
    }

    private static void a(byte[] byArray) {
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            byte by;
            byArray[i2] = by = (byte)(byArray[i2] + 1 & 0xFF);
            if (by != 0) break;
        }
    }
}

