/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.generators;

import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.DerivationParameters;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.MacDerivationFunction;
import com.enterprisedt.bouncycastle.crypto.params.KDFDoublePipelineIterationParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import java.math.BigInteger;

public class KDFDoublePipelineIterationBytesGenerator
implements MacDerivationFunction {
    private static final BigInteger a = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger b = BigInteger.valueOf(2L);
    private final Mac c;
    private final int d;
    private byte[] e;
    private int f;
    private byte[] g;
    private boolean h;
    private int i;
    private byte[] j;
    private byte[] k;

    public KDFDoublePipelineIterationBytesGenerator(Mac prf) {
        this.c = prf;
        this.d = prf.getMacSize();
        this.j = new byte[this.d];
        this.k = new byte[this.d];
    }

    @Override
    public void init(DerivationParameters params) {
        BigInteger bigInteger;
        if (!(params instanceof KDFDoublePipelineIterationParameters)) {
            throw new IllegalArgumentException("Wrong type of arguments given");
        }
        KDFDoublePipelineIterationParameters kDFDoublePipelineIterationParameters = (KDFDoublePipelineIterationParameters)params;
        this.c.init(new KeyParameter(kDFDoublePipelineIterationParameters.getKI()));
        this.e = kDFDoublePipelineIterationParameters.getFixedInputData();
        int n2 = kDFDoublePipelineIterationParameters.getR();
        this.g = new byte[n2 / 8];
        this.f = kDFDoublePipelineIterationParameters.useCounter() ? ((bigInteger = b.pow(n2).multiply(BigInteger.valueOf(this.d))).compareTo(a) == 1 ? Integer.MAX_VALUE : bigInteger.intValue()) : Integer.MAX_VALUE;
        this.h = kDFDoublePipelineIterationParameters.useCounter();
        this.i = 0;
    }

    @Override
    public Mac getMac() {
        return this.c;
    }

    @Override
    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        int n2 = this.i + len;
        if (n2 < 0 || n2 >= this.f) {
            throw new DataLengthException("Current KDFCTR may only be used for " + this.f + " bytes");
        }
        if (this.i % this.d == 0) {
            this.a();
        }
        int n3 = len;
        int n4 = this.i % this.d;
        int n5 = this.d - this.i % this.d;
        int n6 = Math.min(n5, n3);
        System.arraycopy(this.k, n4, out, outOff, n6);
        this.i += n6;
        n3 -= n6;
        outOff += n6;
        while (n3 > 0) {
            this.a();
            n6 = Math.min(this.d, n3);
            System.arraycopy(this.k, 0, out, outOff, n6);
            this.i += n6;
            n3 -= n6;
            outOff += n6;
        }
        return len;
    }

    private void a() {
        if (this.i == 0) {
            this.c.update(this.e, 0, this.e.length);
            this.c.doFinal(this.j, 0);
        } else {
            this.c.update(this.j, 0, this.j.length);
            this.c.doFinal(this.j, 0);
        }
        this.c.update(this.j, 0, this.j.length);
        if (this.h) {
            int n2 = this.i / this.d + 1;
            switch (this.g.length) {
                case 4: {
                    this.g[0] = (byte)(n2 >>> 24);
                }
                case 3: {
                    this.g[this.g.length - 3] = (byte)(n2 >>> 16);
                }
                case 2: {
                    this.g[this.g.length - 2] = (byte)(n2 >>> 8);
                }
                case 1: {
                    this.g[this.g.length - 1] = (byte)n2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported size of counter i");
                }
            }
            this.c.update(this.g, 0, this.g.length);
        }
        this.c.update(this.e, 0, this.e.length);
        this.c.doFinal(this.k, 0);
    }
}

