/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.generators;

import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.generators.BCrypt;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.util.HashSet;
import java.util.Set;

public class OpenBSDBCrypt {
    private static final byte[] a;
    private static final byte[] b;
    private static final Set<String> c;

    private static String a(String string, byte[] byArray, byte[] byArray2, int n2) {
        if (!c.contains(string)) {
            throw new IllegalArgumentException("Version " + string + " is not accepted by this implementation.");
        }
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append('$');
        stringBuffer.append(string);
        stringBuffer.append('$');
        stringBuffer.append(n2 < 10 ? "0" + n2 : Integer.toString(n2));
        stringBuffer.append('$');
        stringBuffer.append(OpenBSDBCrypt.a(byArray2));
        byte[] byArray3 = BCrypt.generate(byArray, byArray2, n2);
        stringBuffer.append(OpenBSDBCrypt.a(byArray3));
        return stringBuffer.toString();
    }

    public static String generate(char[] password, byte[] salt, int cost) {
        return OpenBSDBCrypt.generate("2y", password, salt, cost);
    }

    public static String generate(String version, char[] password, byte[] salt, int cost) {
        if (!c.contains(version)) {
            throw new IllegalArgumentException("Version " + version + " is not accepted by this implementation.");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password required.");
        }
        if (salt == null) {
            throw new IllegalArgumentException("Salt required.");
        }
        if (salt.length != 16) {
            throw new DataLengthException("16 byte salt required: " + salt.length);
        }
        if (cost < 4 || cost > 31) {
            throw new IllegalArgumentException("Invalid cost factor.");
        }
        byte[] byArray = Strings.toUTF8ByteArray(password);
        byte[] byArray2 = new byte[byArray.length >= 72 ? 72 : byArray.length + 1];
        if (byArray2.length > byArray.length) {
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        }
        Arrays.fill(byArray, (byte)0);
        String string = OpenBSDBCrypt.a(version, byArray2, salt, cost);
        Arrays.fill(byArray2, (byte)0);
        return string;
    }

    public static boolean checkPassword(String bcryptString, char[] password) {
        if (bcryptString.length() != 60) {
            throw new DataLengthException("Bcrypt String length: " + bcryptString.length() + ", 60 required.");
        }
        if (bcryptString.charAt(0) != '$' || bcryptString.charAt(3) != '$' || bcryptString.charAt(6) != '$') {
            throw new IllegalArgumentException("Invalid Bcrypt String format.");
        }
        String string = bcryptString.substring(1, 3);
        if (!c.contains(string)) {
            throw new IllegalArgumentException("Bcrypt version '" + string + "' is not supported by this implementation");
        }
        int n2 = 0;
        String string2 = bcryptString.substring(4, 6);
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid cost factor: " + string2);
        }
        if (n2 < 4 || n2 > 31) {
            throw new IllegalArgumentException("Invalid cost factor: " + n2 + ", 4 < cost < 31 expected.");
        }
        if (password == null) {
            throw new IllegalArgumentException("Missing password.");
        }
        byte[] byArray = OpenBSDBCrypt.a(bcryptString.substring(bcryptString.lastIndexOf(36) + 1, bcryptString.length() - 31));
        String string3 = OpenBSDBCrypt.generate(string, password, byArray, n2);
        return bcryptString.equals(string3);
    }

    private static String a(byte[] byArray) {
        Object object;
        if (byArray.length != 24 && byArray.length != 16) {
            throw new DataLengthException("Invalid length: " + byArray.length + ", 24 for key or 16 for salt expected");
        }
        boolean bl = false;
        if (byArray.length == 16) {
            bl = true;
            object = new byte[18];
            System.arraycopy(byArray, 0, object, 0, byArray.length);
            byArray = object;
        } else {
            byArray[byArray.length - 1] = 0;
        }
        object = new ByteArrayOutputStream();
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; i2 += 3) {
            int n3 = byArray[i2] & 0xFF;
            int n4 = byArray[i2 + 1] & 0xFF;
            int n5 = byArray[i2 + 2] & 0xFF;
            ((ByteArrayOutputStream)object).write(a[n3 >>> 2 & 0x3F]);
            ((ByteArrayOutputStream)object).write(a[(n3 << 4 | n4 >>> 4) & 0x3F]);
            ((ByteArrayOutputStream)object).write(a[(n4 << 2 | n5 >>> 6) & 0x3F]);
            ((ByteArrayOutputStream)object).write(a[n5 & 0x3F]);
        }
        String string = Strings.fromByteArray(((ByteArrayOutputStream)object).toByteArray());
        if (bl) {
            return string.substring(0, 22);
        }
        return string.substring(0, string.length() - 1);
    }

    private static byte[] a(String string) {
        int n2;
        char[] cArray = string.toCharArray();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16);
        if (cArray.length != 22) {
            throw new DataLengthException("Invalid base64 salt length: " + cArray.length + " , 22 required.");
        }
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            n2 = cArray[i2];
            if (n2 <= 122 && n2 >= 46 && (n2 <= 57 || n2 >= 65)) continue;
            throw new IllegalArgumentException("Salt string contains invalid character: " + n2);
        }
        char[] cArray2 = new char[24];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        cArray = cArray2;
        n2 = cArray.length;
        for (int i3 = 0; i3 < n2; i3 += 4) {
            byte by = b[cArray[i3]];
            byte by2 = b[cArray[i3 + 1]];
            byte by3 = b[cArray[i3 + 2]];
            byte by4 = b[cArray[i3 + 3]];
            byteArrayOutputStream.write(by << 2 | by2 >> 4);
            byteArrayOutputStream.write(by2 << 4 | by3 >> 2);
            byteArrayOutputStream.write(by3 << 6 | by4);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        byArray = byArray2;
        return byArray;
    }

    static {
        int n2;
        a = new byte[]{46, 47, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
        b = new byte[128];
        c = new HashSet<String>();
        c.add("2a");
        c.add("2y");
        c.add("2b");
        for (n2 = 0; n2 < b.length; ++n2) {
            OpenBSDBCrypt.b[n2] = -1;
        }
        for (n2 = 0; n2 < a.length; ++n2) {
            OpenBSDBCrypt.b[OpenBSDBCrypt.a[n2]] = (byte)n2;
        }
    }
}

