/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.kems;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DerivationFunction;
import com.enterprisedt.bouncycastle.crypto.KeyEncapsulation;
import com.enterprisedt.bouncycastle.crypto.params.KDFParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSAKeyEncapsulation
implements KeyEncapsulation {
    private static final BigInteger a = BigInteger.valueOf(0L);
    private static final BigInteger b = BigInteger.valueOf(1L);
    private DerivationFunction c;
    private SecureRandom d;
    private RSAKeyParameters e;

    public RSAKeyEncapsulation(DerivationFunction kdf, SecureRandom rnd) {
        this.c = kdf;
        this.d = rnd;
    }

    @Override
    public void init(CipherParameters key) throws IllegalArgumentException {
        if (!(key instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("RSA key required");
        }
        this.e = (RSAKeyParameters)key;
    }

    @Override
    public CipherParameters encrypt(byte[] out, int outOff, int keyLen) throws IllegalArgumentException {
        if (this.e.isPrivate()) {
            throw new IllegalArgumentException("Public key required for encryption");
        }
        BigInteger bigInteger = this.e.getModulus();
        BigInteger bigInteger2 = this.e.getExponent();
        BigInteger bigInteger3 = BigIntegers.createRandomInRange(a, bigInteger.subtract(b), this.d);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        byte[] byArray = BigIntegers.asUnsignedByteArray((bigInteger.bitLength() + 7) / 8, bigInteger4);
        System.arraycopy(byArray, 0, out, outOff, byArray.length);
        return this.generateKey(bigInteger, bigInteger3, keyLen);
    }

    public CipherParameters encrypt(byte[] out, int keyLen) {
        return this.encrypt(out, 0, keyLen);
    }

    @Override
    public CipherParameters decrypt(byte[] in, int inOff, int inLen, int keyLen) throws IllegalArgumentException {
        if (!this.e.isPrivate()) {
            throw new IllegalArgumentException("Private key required for decryption");
        }
        BigInteger bigInteger = this.e.getModulus();
        BigInteger bigInteger2 = this.e.getExponent();
        byte[] byArray = new byte[inLen];
        System.arraycopy(in, inOff, byArray, 0, byArray.length);
        BigInteger bigInteger3 = new BigInteger(1, byArray);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        return this.generateKey(bigInteger, bigInteger4, keyLen);
    }

    public CipherParameters decrypt(byte[] in, int keyLen) {
        return this.decrypt(in, 0, in.length, keyLen);
    }

    protected KeyParameter generateKey(BigInteger n2, BigInteger r2, int keyLen) {
        byte[] byArray = BigIntegers.asUnsignedByteArray((n2.bitLength() + 7) / 8, r2);
        this.c.init(new KDFParameters(byArray, null));
        byte[] byArray2 = new byte[keyLen];
        this.c.generateBytes(byArray2, 0, byArray2.length);
        return new KeyParameter(byArray2);
    }
}

