/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.macs;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.modes.CBCBlockCipher;
import com.enterprisedt.bouncycastle.crypto.paddings.ISO7816d4Padding;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.util.Pack;

public class CMac
implements Mac {
    private byte[] a;
    private byte[] b;
    private byte[] c;
    private byte[] d;
    private int e;
    private BlockCipher f;
    private int g;
    private byte[] h;
    private byte[] i;

    public CMac(BlockCipher cipher) {
        this(cipher, cipher.getBlockSize() * 8);
    }

    public CMac(BlockCipher cipher, int macSizeInBits) {
        if (macSizeInBits % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        if (macSizeInBits > cipher.getBlockSize() * 8) {
            throw new IllegalArgumentException("MAC size must be less or equal to " + cipher.getBlockSize() * 8);
        }
        this.f = new CBCBlockCipher(cipher);
        this.g = macSizeInBits / 8;
        this.a = CMac.a(cipher.getBlockSize());
        this.c = new byte[cipher.getBlockSize()];
        this.d = new byte[cipher.getBlockSize()];
        this.b = new byte[cipher.getBlockSize()];
        this.e = 0;
    }

    @Override
    public String getAlgorithmName() {
        return this.f.getAlgorithmName();
    }

    private static int a(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        int n3 = 0;
        while (--n2 >= 0) {
            int n4 = byArray[n2] & 0xFF;
            byArray2[n2] = (byte)(n4 << 1 | n3);
            n3 = n4 >>> 7 & 1;
        }
        return n3;
    }

    private byte[] a(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n2 = CMac.a(byArray, byArray2);
        int n3 = -n2 & 0xFF;
        int n4 = byArray.length - 3;
        byArray2[n4] = (byte)(byArray2[n4] ^ this.a[1] & n3);
        int n5 = byArray.length - 2;
        byArray2[n5] = (byte)(byArray2[n5] ^ this.a[2] & n3);
        int n6 = byArray.length - 1;
        byArray2[n6] = (byte)(byArray2[n6] ^ this.a[3] & n3);
        return byArray2;
    }

    private static byte[] a(int n2) {
        int n3;
        switch (n2 * 8) {
            case 64: {
                n3 = 27;
                break;
            }
            case 128: {
                n3 = 135;
                break;
            }
            case 160: {
                n3 = 45;
                break;
            }
            case 192: {
                n3 = 135;
                break;
            }
            case 224: {
                n3 = 777;
                break;
            }
            case 256: {
                n3 = 1061;
                break;
            }
            case 320: {
                n3 = 27;
                break;
            }
            case 384: {
                n3 = 4109;
                break;
            }
            case 448: {
                n3 = 2129;
                break;
            }
            case 512: {
                n3 = 293;
                break;
            }
            case 768: {
                n3 = 655377;
                break;
            }
            case 1024: {
                n3 = 524355;
                break;
            }
            case 2048: {
                n3 = 548865;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown block size for CMAC: " + n2 * 8);
            }
        }
        return Pack.intToBigEndian(n3);
    }

    @Override
    public void init(CipherParameters params) {
        this.a(params);
        this.f.init(true, params);
        byte[] byArray = new byte[this.b.length];
        this.f.processBlock(this.b, 0, byArray, 0);
        this.h = this.a(byArray);
        this.i = this.a(this.h);
        this.reset();
    }

    void a(CipherParameters cipherParameters) {
        if (cipherParameters != null && !(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("CMac mode only permits key to be set.");
        }
    }

    @Override
    public int getMacSize() {
        return this.g;
    }

    @Override
    public void update(byte in) {
        if (this.e == this.d.length) {
            this.f.processBlock(this.d, 0, this.c, 0);
            this.e = 0;
        }
        this.d[this.e++] = in;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n2 = this.f.getBlockSize();
        int n3 = n2 - this.e;
        if (len > n3) {
            System.arraycopy(in, inOff, this.d, this.e, n3);
            this.f.processBlock(this.d, 0, this.c, 0);
            this.e = 0;
            len -= n3;
            inOff += n3;
            while (len > n2) {
                this.f.processBlock(in, inOff, this.c, 0);
                len -= n2;
                inOff += n2;
            }
        }
        System.arraycopy(in, inOff, this.d, this.e, len);
        this.e += len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        byte[] byArray;
        int n2 = this.f.getBlockSize();
        if (this.e == n2) {
            byArray = this.h;
        } else {
            new ISO7816d4Padding().addPadding(this.d, this.e);
            byArray = this.i;
        }
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            int n3 = i2;
            this.d[n3] = (byte)(this.d[n3] ^ byArray[i2]);
        }
        this.f.processBlock(this.d, 0, this.c, 0);
        System.arraycopy(this.c, 0, out, outOff, this.g);
        this.reset();
        return this.g;
    }

    @Override
    public void reset() {
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            this.d[i2] = 0;
        }
        this.e = 0;
        this.f.reset();
    }
}

