/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.macs;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.engines.DESEngine;
import com.enterprisedt.bouncycastle.crypto.modes.CBCBlockCipher;
import com.enterprisedt.bouncycastle.crypto.paddings.BlockCipherPadding;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;

public class ISO9797Alg3Mac
implements Mac {
    private byte[] a;
    private byte[] b;
    private int c;
    private BlockCipher d;
    private BlockCipherPadding e;
    private int f;
    private KeyParameter g;
    private KeyParameter h;

    public ISO9797Alg3Mac(BlockCipher cipher) {
        this(cipher, cipher.getBlockSize() * 8, null);
    }

    public ISO9797Alg3Mac(BlockCipher cipher, BlockCipherPadding padding) {
        this(cipher, cipher.getBlockSize() * 8, padding);
    }

    public ISO9797Alg3Mac(BlockCipher cipher, int macSizeInBits) {
        this(cipher, macSizeInBits, null);
    }

    public ISO9797Alg3Mac(BlockCipher cipher, int macSizeInBits, BlockCipherPadding padding) {
        if (macSizeInBits % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        if (!(cipher instanceof DESEngine)) {
            throw new IllegalArgumentException("cipher must be instance of DESEngine");
        }
        this.d = new CBCBlockCipher(cipher);
        this.e = padding;
        this.f = macSizeInBits / 8;
        this.a = new byte[cipher.getBlockSize()];
        this.b = new byte[cipher.getBlockSize()];
        this.c = 0;
    }

    @Override
    public String getAlgorithmName() {
        return "ISO9797Alg3";
    }

    @Override
    public void init(CipherParameters params) {
        KeyParameter keyParameter;
        this.reset();
        if (!(params instanceof KeyParameter) && !(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("params must be an instance of KeyParameter or ParametersWithIV");
        }
        KeyParameter keyParameter2 = params instanceof KeyParameter ? (KeyParameter)params : (KeyParameter)((ParametersWithIV)params).getParameters();
        byte[] byArray = keyParameter2.getKey();
        if (byArray.length == 16) {
            keyParameter = new KeyParameter(byArray, 0, 8);
            this.g = new KeyParameter(byArray, 8, 8);
            this.h = keyParameter;
        } else if (byArray.length == 24) {
            keyParameter = new KeyParameter(byArray, 0, 8);
            this.g = new KeyParameter(byArray, 8, 8);
            this.h = new KeyParameter(byArray, 16, 8);
        } else {
            throw new IllegalArgumentException("Key must be either 112 or 168 bit long");
        }
        if (params instanceof ParametersWithIV) {
            this.d.init(true, new ParametersWithIV(keyParameter, ((ParametersWithIV)params).getIV()));
        } else {
            this.d.init(true, keyParameter);
        }
    }

    @Override
    public int getMacSize() {
        return this.f;
    }

    @Override
    public void update(byte in) {
        if (this.c == this.b.length) {
            this.d.processBlock(this.b, 0, this.a, 0);
            this.c = 0;
        }
        this.b[this.c++] = in;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n2 = this.d.getBlockSize();
        int n3 = 0;
        int n4 = n2 - this.c;
        if (len > n4) {
            System.arraycopy(in, inOff, this.b, this.c, n4);
            n3 += this.d.processBlock(this.b, 0, this.a, 0);
            this.c = 0;
            len -= n4;
            inOff += n4;
            while (len > n2) {
                n3 += this.d.processBlock(in, inOff, this.a, 0);
                len -= n2;
                inOff += n2;
            }
        }
        System.arraycopy(in, inOff, this.b, this.c, len);
        this.c += len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        int n2 = this.d.getBlockSize();
        if (this.e == null) {
            while (this.c < n2) {
                this.b[this.c] = 0;
                ++this.c;
            }
        } else {
            if (this.c == n2) {
                this.d.processBlock(this.b, 0, this.a, 0);
                this.c = 0;
            }
            this.e.addPadding(this.b, this.c);
        }
        this.d.processBlock(this.b, 0, this.a, 0);
        DESEngine dESEngine = new DESEngine();
        dESEngine.init(false, this.g);
        dESEngine.processBlock(this.a, 0, this.a, 0);
        dESEngine.init(true, this.h);
        dESEngine.processBlock(this.a, 0, this.a, 0);
        System.arraycopy(this.a, 0, out, outOff, this.f);
        this.reset();
        return this.f;
    }

    @Override
    public void reset() {
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            this.b[i2] = 0;
        }
        this.c = 0;
        this.d.reset();
    }
}

