/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.macs;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Mac;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.util.Pack;

public class SipHash
implements Mac {
    protected final int c;
    protected final int d;
    protected long k0;
    protected long k1;
    protected long v0;
    protected long v1;
    protected long v2;
    protected long v3;
    protected long m = 0L;
    protected int wordPos = 0;
    protected int wordCount = 0;

    public SipHash() {
        this.c = 2;
        this.d = 4;
    }

    public SipHash(int c2, int d2) {
        this.c = c2;
        this.d = d2;
    }

    @Override
    public String getAlgorithmName() {
        return "SipHash-" + this.c + "-" + this.d;
    }

    @Override
    public int getMacSize() {
        return 8;
    }

    @Override
    public void init(CipherParameters params) throws IllegalArgumentException {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("'params' must be an instance of KeyParameter");
        }
        KeyParameter keyParameter = (KeyParameter)params;
        byte[] byArray = keyParameter.getKey();
        if (byArray.length != 16) {
            throw new IllegalArgumentException("'params' must be a 128-bit key");
        }
        this.k0 = Pack.littleEndianToLong(byArray, 0);
        this.k1 = Pack.littleEndianToLong(byArray, 8);
        this.reset();
    }

    @Override
    public void update(byte input) throws IllegalStateException {
        this.m >>>= 8;
        this.m |= ((long)input & 0xFFL) << 56;
        if (++this.wordPos == 8) {
            this.processMessageWord();
            this.wordPos = 0;
        }
    }

    @Override
    public void update(byte[] input, int offset, int length) throws DataLengthException, IllegalStateException {
        int n2;
        int n3 = length & 0xFFFFFFF8;
        if (this.wordPos == 0) {
            for (n2 = 0; n2 < n3; n2 += 8) {
                this.m = Pack.littleEndianToLong(input, offset + n2);
                this.processMessageWord();
            }
            while (n2 < length) {
                this.m >>>= 8;
                this.m |= ((long)input[offset + n2] & 0xFFL) << 56;
                ++n2;
            }
            this.wordPos = length - n3;
        } else {
            int n4 = this.wordPos << 3;
            while (n2 < n3) {
                long l2 = Pack.littleEndianToLong(input, offset + n2);
                this.m = l2 << n4 | this.m >>> -n4;
                this.processMessageWord();
                this.m = l2;
                n2 += 8;
            }
            while (n2 < length) {
                this.m >>>= 8;
                this.m |= ((long)input[offset + n2] & 0xFFL) << 56;
                if (++this.wordPos == 8) {
                    this.processMessageWord();
                    this.wordPos = 0;
                }
                ++n2;
            }
        }
    }

    public long doFinal() throws DataLengthException, IllegalStateException {
        this.m >>>= 7 - this.wordPos << 3;
        this.m >>>= 8;
        this.m |= ((long)((this.wordCount << 3) + this.wordPos) & 0xFFL) << 56;
        this.processMessageWord();
        this.v2 ^= 0xFFL;
        this.applySipRounds(this.d);
        long l2 = this.v0 ^ this.v1 ^ this.v2 ^ this.v3;
        this.reset();
        return l2;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        long l2 = this.doFinal();
        Pack.longToLittleEndian(l2, out, outOff);
        return 8;
    }

    @Override
    public void reset() {
        this.v0 = this.k0 ^ 0x736F6D6570736575L;
        this.v1 = this.k1 ^ 0x646F72616E646F6DL;
        this.v2 = this.k0 ^ 0x6C7967656E657261L;
        this.v3 = this.k1 ^ 0x7465646279746573L;
        this.m = 0L;
        this.wordPos = 0;
        this.wordCount = 0;
    }

    protected void processMessageWord() {
        ++this.wordCount;
        this.v3 ^= this.m;
        this.applySipRounds(this.c);
        this.v0 ^= this.m;
    }

    protected void applySipRounds(int n2) {
        long l2 = this.v0;
        long l3 = this.v1;
        long l4 = this.v2;
        long l5 = this.v3;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 += l3;
            l4 += l5;
            l3 = SipHash.rotateLeft(l3, 13);
            l5 = SipHash.rotateLeft(l5, 16);
            l3 ^= l2;
            l5 ^= l4;
            l2 = SipHash.rotateLeft(l2, 32);
            l4 += l3;
            l2 += l5;
            l3 = SipHash.rotateLeft(l3, 17);
            l5 = SipHash.rotateLeft(l5, 21);
            l3 ^= l4;
            l5 ^= l2;
            l4 = SipHash.rotateLeft(l4, 32);
        }
        this.v0 = l2;
        this.v1 = l3;
        this.v2 = l4;
        this.v3 = l5;
    }

    protected static long rotateLeft(long x2, int n2) {
        return x2 << n2 | x2 >>> -n2;
    }
}

