/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.macs.CBCBlockCipherMac;
import com.enterprisedt.bouncycastle.crypto.modes.AEADBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.SICBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.AEADParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;

public class CCMBlockCipher
implements AEADBlockCipher {
    private BlockCipher a;
    private int b;
    private boolean c;
    private byte[] d;
    private byte[] e;
    private int f;
    private CipherParameters g;
    private byte[] h;
    private a i = new a();
    private a j = new a();

    public CCMBlockCipher(BlockCipher c2) {
        this.a = c2;
        this.b = c2.getBlockSize();
        this.h = new byte[this.b];
        if (this.b != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.a;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        CipherParameters cipherParameters;
        this.c = forEncryption;
        if (params instanceof AEADParameters) {
            AEADParameters aEADParameters = (AEADParameters)params;
            this.d = aEADParameters.getNonce();
            this.e = aEADParameters.getAssociatedText();
            this.f = aEADParameters.getMacSize() / 8;
            cipherParameters = aEADParameters.getKey();
        } else if (params instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)params;
            this.d = parametersWithIV.getIV();
            this.e = null;
            this.f = this.h.length / 2;
            cipherParameters = parametersWithIV.getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to CCM: " + params.getClass().getName());
        }
        if (cipherParameters != null) {
            this.g = cipherParameters;
        }
        if (this.d == null || this.d.length < 7 || this.d.length > 13) {
            throw new IllegalArgumentException("nonce must have length from 7 to 13 octets");
        }
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getAlgorithmName() + "/CCM";
    }

    @Override
    public void processAADByte(byte in) {
        this.i.write(in);
    }

    @Override
    public void processAADBytes(byte[] in, int inOff, int len) {
        this.i.write(in, inOff, len);
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.j.write(in);
        return 0;
    }

    @Override
    public int processBytes(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (in.length < inOff + inLen) {
            throw new DataLengthException("Input buffer too short");
        }
        this.j.write(in, inOff, inLen);
        return 0;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int n2 = this.processPacket(this.j.a(), 0, this.j.size(), out, outOff);
        this.reset();
        return n2;
    }

    @Override
    public void reset() {
        this.a.reset();
        this.i.reset();
        this.j.reset();
    }

    @Override
    public byte[] getMac() {
        byte[] byArray = new byte[this.f];
        System.arraycopy(this.h, 0, byArray, 0, byArray.length);
        return byArray;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return 0;
    }

    @Override
    public int getOutputSize(int len) {
        int n2 = len + this.j.size();
        if (this.c) {
            return n2 + this.f;
        }
        return n2 < this.f ? 0 : n2 - this.f;
    }

    public byte[] processPacket(byte[] in, int inOff, int inLen) throws IllegalStateException, InvalidCipherTextException {
        byte[] byArray;
        if (this.c) {
            byArray = new byte[inLen + this.f];
        } else {
            if (inLen < this.f) {
                throw new InvalidCipherTextException("data too short");
            }
            byArray = new byte[inLen - this.f];
        }
        this.processPacket(in, inOff, inLen, byArray, 0);
        return byArray;
    }

    public int processPacket(byte[] in, int inOff, int inLen, byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException, DataLengthException {
        int n2;
        int n3;
        int n4;
        if (this.g == null) {
            throw new IllegalStateException("CCM cipher unitialized.");
        }
        int n5 = this.d.length;
        int n6 = 15 - n5;
        if (n6 < 4 && inLen >= (n4 = 1 << 8 * n6)) {
            throw new IllegalStateException("CCM packet too large for choice of q.");
        }
        byte[] byArray = new byte[this.b];
        byArray[0] = (byte)(n6 - 1 & 7);
        System.arraycopy(this.d, 0, byArray, 1, this.d.length);
        SICBlockCipher sICBlockCipher = new SICBlockCipher(this.a);
        sICBlockCipher.init(this.c, new ParametersWithIV(this.g, byArray));
        int n7 = outOff;
        if (this.c) {
            n3 = inLen + this.f;
            if (output.length < n3 + outOff) {
                throw new OutputLengthException("Output buffer too short.");
            }
            this.a(in, inOff, inLen, this.h);
            byte[] byArray2 = new byte[this.b];
            sICBlockCipher.processBlock(this.h, 0, byArray2, 0);
            for (n2 = inOff; n2 < inOff + inLen - this.b; n2 += this.b) {
                sICBlockCipher.processBlock(in, n2, output, n7);
                n7 += this.b;
            }
            byte[] byArray3 = new byte[this.b];
            System.arraycopy(in, n2, byArray3, 0, inLen + inOff - n2);
            sICBlockCipher.processBlock(byArray3, 0, byArray3, 0);
            System.arraycopy(byArray3, 0, output, n7, inLen + inOff - n2);
            System.arraycopy(byArray2, 0, output, outOff + inLen, this.f);
        } else {
            if (inLen < this.f) {
                throw new InvalidCipherTextException("data too short");
            }
            n3 = inLen - this.f;
            if (output.length < n3 + outOff) {
                throw new OutputLengthException("Output buffer too short.");
            }
            System.arraycopy(in, inOff + n3, this.h, 0, this.f);
            sICBlockCipher.processBlock(this.h, 0, this.h, 0);
            for (int i2 = this.f; i2 != this.h.length; ++i2) {
                this.h[i2] = 0;
            }
            while (n2 < inOff + n3 - this.b) {
                sICBlockCipher.processBlock(in, n2, output, n7);
                n7 += this.b;
                n2 += this.b;
            }
            byte[] byArray4 = new byte[this.b];
            System.arraycopy(in, n2, byArray4, 0, n3 - (n2 - inOff));
            sICBlockCipher.processBlock(byArray4, 0, byArray4, 0);
            System.arraycopy(byArray4, 0, output, n7, n3 - (n2 - inOff));
            byte[] byArray5 = new byte[this.b];
            this.a(output, outOff, n3, byArray5);
            if (!Arrays.constantTimeAreEqual(this.h, byArray5)) {
                throw new InvalidCipherTextException("mac check in CCM failed");
            }
        }
        return n3;
    }

    private int a(byte[] byArray, int n2, int n3, byte[] byArray2) {
        CBCBlockCipherMac cBCBlockCipherMac = new CBCBlockCipherMac(this.a, this.f * 8);
        cBCBlockCipherMac.init(this.g);
        byte[] byArray3 = new byte[16];
        if (this.b()) {
            byArray3[0] = (byte)(byArray3[0] | 0x40);
        }
        byArray3[0] = (byte)(byArray3[0] | ((cBCBlockCipherMac.getMacSize() - 2) / 2 & 7) << 3);
        byArray3[0] = (byte)(byArray3[0] | 15 - this.d.length - 1 & 7);
        System.arraycopy(this.d, 0, byArray3, 1, this.d.length);
        int n4 = n3;
        int n5 = 1;
        while (n4 > 0) {
            byArray3[byArray3.length - n5] = (byte)(n4 & 0xFF);
            n4 >>>= 8;
            ++n5;
        }
        cBCBlockCipherMac.update(byArray3, 0, byArray3.length);
        if (this.b()) {
            int n6;
            int n7 = this.a();
            if (n7 < 65280) {
                cBCBlockCipherMac.update((byte)(n7 >> 8));
                cBCBlockCipherMac.update((byte)n7);
                n6 = 2;
            } else {
                cBCBlockCipherMac.update((byte)-1);
                cBCBlockCipherMac.update((byte)-2);
                cBCBlockCipherMac.update((byte)(n7 >> 24));
                cBCBlockCipherMac.update((byte)(n7 >> 16));
                cBCBlockCipherMac.update((byte)(n7 >> 8));
                cBCBlockCipherMac.update((byte)n7);
                n6 = 6;
            }
            if (this.e != null) {
                cBCBlockCipherMac.update(this.e, 0, this.e.length);
            }
            if (this.i.size() > 0) {
                cBCBlockCipherMac.update(this.i.a(), 0, this.i.size());
            }
            if ((n6 = (n6 + n7) % 16) != 0) {
                for (int i2 = n6; i2 != 16; ++i2) {
                    cBCBlockCipherMac.update((byte)0);
                }
            }
        }
        cBCBlockCipherMac.update(byArray, n2, n3);
        return cBCBlockCipherMac.doFinal(byArray2, 0);
    }

    private int a() {
        return this.i.size() + (this.e == null ? 0 : this.e.length);
    }

    private boolean b() {
        return this.a() > 0;
    }

    private class a
    extends ByteArrayOutputStream {
        public byte[] a() {
            return this.buf;
        }
    }
}

