/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.BufferedBlockCipher;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.StreamBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.CBCBlockCipher;

public class CTSBlockCipher
extends BufferedBlockCipher {
    private int a;

    public CTSBlockCipher(BlockCipher cipher) {
        if (cipher instanceof StreamBlockCipher) {
            throw new IllegalArgumentException("CTSBlockCipher can only accept ECB, or CBC ciphers");
        }
        this.cipher = cipher;
        this.a = cipher.getBlockSize();
        this.buf = new byte[this.a * 2];
        this.bufOff = 0;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        int n2 = len + this.bufOff;
        int n3 = n2 % this.buf.length;
        if (n3 == 0) {
            return n2 - this.buf.length;
        }
        return n2 - n3;
    }

    @Override
    public int getOutputSize(int len) {
        return len + this.bufOff;
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        int n2 = 0;
        if (this.bufOff == this.buf.length) {
            n2 = this.cipher.processBlock(this.buf, 0, out, outOff);
            System.arraycopy(this.buf, this.a, this.buf, 0, this.a);
            this.bufOff = this.a;
        }
        this.buf[this.bufOff++] = in;
        return n2;
    }

    @Override
    public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n2 = this.getBlockSize();
        int n3 = this.getUpdateOutputSize(len);
        if (n3 > 0 && outOff + n3 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int n4 = 0;
        int n5 = this.buf.length - this.bufOff;
        if (len > n5) {
            System.arraycopy(in, inOff, this.buf, this.bufOff, n5);
            n4 += this.cipher.processBlock(this.buf, 0, out, outOff);
            System.arraycopy(this.buf, n2, this.buf, 0, n2);
            this.bufOff = n2;
            len -= n5;
            inOff += n5;
            while (len > n2) {
                System.arraycopy(in, inOff, this.buf, this.bufOff, n2);
                n4 += this.cipher.processBlock(this.buf, 0, out, outOff + n4);
                System.arraycopy(this.buf, n2, this.buf, 0, n2);
                len -= n2;
                inOff += n2;
            }
        }
        System.arraycopy(in, inOff, this.buf, this.bufOff, len);
        this.bufOff += len;
        return n4;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        if (this.bufOff + outOff > out.length) {
            throw new OutputLengthException("output buffer to small in doFinal");
        }
        int n2 = this.cipher.getBlockSize();
        int n3 = this.bufOff - n2;
        byte[] byArray = new byte[n2];
        if (this.forEncryption) {
            if (this.bufOff < n2) {
                throw new DataLengthException("need at least one block of input for CTS");
            }
            this.cipher.processBlock(this.buf, 0, byArray, 0);
            if (this.bufOff > n2) {
                int n4;
                for (n4 = this.bufOff; n4 != this.buf.length; ++n4) {
                    this.buf[n4] = byArray[n4 - n2];
                }
                for (n4 = n2; n4 != this.bufOff; ++n4) {
                    int n5 = n4;
                    this.buf[n5] = (byte)(this.buf[n5] ^ byArray[n4 - n2]);
                }
                if (this.cipher instanceof CBCBlockCipher) {
                    BlockCipher blockCipher = ((CBCBlockCipher)this.cipher).getUnderlyingCipher();
                    blockCipher.processBlock(this.buf, n2, out, outOff);
                } else {
                    this.cipher.processBlock(this.buf, n2, out, outOff);
                }
                System.arraycopy(byArray, 0, out, outOff + n2, n3);
            } else {
                System.arraycopy(byArray, 0, out, outOff, n2);
            }
        } else {
            if (this.bufOff < n2) {
                throw new DataLengthException("need at least one block of input for CTS");
            }
            byte[] byArray2 = new byte[n2];
            if (this.bufOff > n2) {
                if (this.cipher instanceof CBCBlockCipher) {
                    BlockCipher blockCipher = ((CBCBlockCipher)this.cipher).getUnderlyingCipher();
                    blockCipher.processBlock(this.buf, 0, byArray, 0);
                } else {
                    this.cipher.processBlock(this.buf, 0, byArray, 0);
                }
                for (int i2 = n2; i2 != this.bufOff; ++i2) {
                    byArray2[i2 - n2] = (byte)(byArray[i2 - n2] ^ this.buf[i2]);
                }
                System.arraycopy(this.buf, n2, byArray, 0, n3);
                this.cipher.processBlock(byArray, 0, out, outOff);
                System.arraycopy(byArray2, 0, out, outOff + n2, n3);
            } else {
                this.cipher.processBlock(this.buf, 0, byArray, 0);
                System.arraycopy(byArray, 0, out, outOff, n2);
            }
        }
        int n6 = this.bufOff;
        this.reset();
        return n6;
    }
}

