/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.BufferedBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Pack;

public class KXTSBlockCipher
extends BufferedBlockCipher {
    private final int a;
    private final long b;
    private final long[] c;
    private final long[] d;
    private int e;

    protected static long getReductionPolynomial(int blockSize) {
        switch (blockSize) {
            case 16: {
                return 135L;
            }
            case 32: {
                return 1061L;
            }
            case 64: {
                return 293L;
            }
        }
        throw new IllegalArgumentException("Only 128, 256, and 512 -bit block sizes supported");
    }

    public KXTSBlockCipher(BlockCipher cipher) {
        this.cipher = cipher;
        this.a = cipher.getBlockSize();
        this.b = KXTSBlockCipher.getReductionPolynomial(this.a);
        this.c = new long[this.a >>> 3];
        this.d = new long[this.a >>> 3];
        this.e = -1;
    }

    @Override
    public int getOutputSize(int length) {
        return length;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return len;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters parameters) {
        if (!(parameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("Invalid parameters passed");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)parameters;
        parameters = parametersWithIV.getParameters();
        byte[] byArray = parametersWithIV.getIV();
        if (byArray.length != this.a) {
            throw new IllegalArgumentException("Currently only support IVs of exactly one block");
        }
        byte[] byArray2 = new byte[this.a];
        System.arraycopy(byArray, 0, byArray2, 0, this.a);
        this.cipher.init(true, parameters);
        this.cipher.processBlock(byArray2, 0, byArray2, 0);
        this.cipher.init(forEncryption, parameters);
        Pack.littleEndianToLong(byArray2, 0, this.c);
        System.arraycopy(this.c, 0, this.d, 0, this.c.length);
        this.e = 0;
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) {
        throw new IllegalStateException("unsupported operation");
    }

    @Override
    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) {
        if (input.length - inOff < len) {
            throw new DataLengthException("Input buffer too short");
        }
        if (output.length - inOff < len) {
            throw new OutputLengthException("Output buffer too short");
        }
        if (len % this.a != 0) {
            throw new IllegalArgumentException("Partial blocks not supported");
        }
        for (int i2 = 0; i2 < len; i2 += this.a) {
            this.a(input, inOff + i2, output, outOff + i2);
        }
        return len;
    }

    private void a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        if (this.e == -1) {
            throw new IllegalStateException("Attempt to process too many blocks");
        }
        ++this.e;
        KXTSBlockCipher.a(this.b, this.d);
        byte[] byArray3 = new byte[this.a];
        Pack.longToLittleEndian(this.d, byArray3, 0);
        byte[] byArray4 = new byte[this.a];
        System.arraycopy(byArray3, 0, byArray4, 0, this.a);
        for (n4 = 0; n4 < this.a; ++n4) {
            int n5 = n4;
            byArray4[n5] = (byte)(byArray4[n5] ^ byArray[n2 + n4]);
        }
        this.cipher.processBlock(byArray4, 0, byArray4, 0);
        for (n4 = 0; n4 < this.a; ++n4) {
            byArray2[n3 + n4] = (byte)(byArray4[n4] ^ byArray3[n4]);
        }
    }

    @Override
    public int doFinal(byte[] output, int outOff) {
        this.reset();
        return 0;
    }

    @Override
    public void reset() {
        this.cipher.reset();
        System.arraycopy(this.c, 0, this.d, 0, this.c.length);
        this.e = 0;
    }

    private static void a(long l2, long[] lArray) {
        long l3 = 0L;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            long l4 = lArray[i2];
            long l5 = l4 >>> 63;
            lArray[i2] = l4 << 1 ^ l3;
            l3 = l5;
        }
        lArray[0] = lArray[0] ^ l2 & -l3;
    }
}

