/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.StreamBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;

public class OFBBlockCipher
extends StreamBlockCipher {
    private int a;
    private byte[] b;
    private byte[] c;
    private byte[] d;
    private final int e;
    private final BlockCipher f;

    public OFBBlockCipher(BlockCipher cipher, int blockSize) {
        super(cipher);
        this.f = cipher;
        this.e = blockSize / 8;
        this.b = new byte[cipher.getBlockSize()];
        this.c = new byte[cipher.getBlockSize()];
        this.d = new byte[cipher.getBlockSize()];
    }

    @Override
    public void init(boolean encrypting, CipherParameters params) throws IllegalArgumentException {
        if (params instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)params;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.b.length) {
                System.arraycopy(byArray, 0, this.b, this.b.length - byArray.length, byArray.length);
                for (int i2 = 0; i2 < this.b.length - byArray.length; ++i2) {
                    this.b[i2] = 0;
                }
            } else {
                System.arraycopy(byArray, 0, this.b, 0, this.b.length);
            }
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.f.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.reset();
            if (params != null) {
                this.f.init(true, params);
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.f.getAlgorithmName() + "/OFB" + this.e * 8;
    }

    @Override
    public int getBlockSize() {
        return this.e;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.processBytes(in, inOff, this.e, out, outOff);
        return this.e;
    }

    @Override
    public void reset() {
        System.arraycopy(this.b, 0, this.c, 0, this.b.length);
        this.a = 0;
        this.f.reset();
    }

    @Override
    protected byte calculateByte(byte in) throws DataLengthException, IllegalStateException {
        if (this.a == 0) {
            this.f.processBlock(this.c, 0, this.d, 0);
        }
        byte by = (byte)(this.d[this.a++] ^ in);
        if (this.a == this.e) {
            this.a = 0;
            System.arraycopy(this.c, this.e, this.c, 0, this.c.length - this.e);
            System.arraycopy(this.d, 0, this.c, this.c.length - this.e, this.e);
        }
        return by;
    }
}

