/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.OutputLengthException;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;

public class PGPCFBBlockCipher
implements BlockCipher {
    private byte[] a;
    private byte[] b;
    private byte[] c;
    private byte[] d;
    private BlockCipher e;
    private int f;
    private int g;
    private boolean h;
    private boolean i;

    public PGPCFBBlockCipher(BlockCipher cipher, boolean inlineIv) {
        this.e = cipher;
        this.i = inlineIv;
        this.g = cipher.getBlockSize();
        this.a = new byte[this.g];
        this.b = new byte[this.g];
        this.c = new byte[this.g];
        this.d = new byte[this.g];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.e;
    }

    @Override
    public String getAlgorithmName() {
        if (this.i) {
            return this.e.getAlgorithmName() + "/PGPCFBwithIV";
        }
        return this.e.getAlgorithmName() + "/PGPCFB";
    }

    @Override
    public int getBlockSize() {
        return this.e.getBlockSize();
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this.i) {
            return this.h ? this.a(in, inOff, out, outOff) : this.b(in, inOff, out, outOff);
        }
        return this.h ? this.c(in, inOff, out, outOff) : this.d(in, inOff, out, outOff);
    }

    @Override
    public void reset() {
        this.f = 0;
        for (int i2 = 0; i2 != this.b.length; ++i2) {
            this.b[i2] = this.i ? (byte)0 : this.a[i2];
        }
        this.e.reset();
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.h = forEncryption;
        if (params instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)params;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.a.length) {
                System.arraycopy(byArray, 0, this.a, this.a.length - byArray.length, byArray.length);
                for (int i2 = 0; i2 < this.a.length - byArray.length; ++i2) {
                    this.a[i2] = 0;
                }
            } else {
                System.arraycopy(byArray, 0, this.a, 0, this.a.length);
            }
            this.reset();
            this.e.init(true, parametersWithIV.getParameters());
        } else {
            this.reset();
            this.e.init(true, params);
        }
    }

    private byte a(byte by, int n2) {
        return (byte)(this.c[n2] ^ by);
    }

    private int a(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (n2 + this.g > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (this.f == 0) {
            int n4;
            if (n3 + 2 * this.g + 2 > byArray2.length) {
                throw new OutputLengthException("output buffer too short");
            }
            this.e.processBlock(this.b, 0, this.c, 0);
            for (n4 = 0; n4 < this.g; ++n4) {
                byArray2[n3 + n4] = this.a(this.a[n4], n4);
            }
            System.arraycopy(byArray2, n3, this.b, 0, this.g);
            this.e.processBlock(this.b, 0, this.c, 0);
            byArray2[n3 + this.g] = this.a(this.a[this.g - 2], 0);
            byArray2[n3 + this.g + 1] = this.a(this.a[this.g - 1], 1);
            System.arraycopy(byArray2, n3 + 2, this.b, 0, this.g);
            this.e.processBlock(this.b, 0, this.c, 0);
            for (n4 = 0; n4 < this.g; ++n4) {
                byArray2[n3 + this.g + 2 + n4] = this.a(byArray[n2 + n4], n4);
            }
            System.arraycopy(byArray2, n3 + this.g + 2, this.b, 0, this.g);
            this.f += 2 * this.g + 2;
            return 2 * this.g + 2;
        }
        if (this.f >= this.g + 2) {
            if (n3 + this.g > byArray2.length) {
                throw new OutputLengthException("output buffer too short");
            }
            this.e.processBlock(this.b, 0, this.c, 0);
            for (int i2 = 0; i2 < this.g; ++i2) {
                byArray2[n3 + i2] = this.a(byArray[n2 + i2], i2);
            }
            System.arraycopy(byArray2, n3, this.b, 0, this.g);
        }
        return this.g;
    }

    private int b(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (n2 + this.g > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + this.g > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.f == 0) {
            for (int i2 = 0; i2 < this.g; ++i2) {
                this.b[i2] = byArray[n2 + i2];
            }
            this.e.processBlock(this.b, 0, this.c, 0);
            this.f += this.g;
            return 0;
        }
        if (this.f == this.g) {
            System.arraycopy(byArray, n2, this.d, 0, this.g);
            System.arraycopy(this.b, 2, this.b, 0, this.g - 2);
            this.b[this.g - 2] = this.d[0];
            this.b[this.g - 1] = this.d[1];
            this.e.processBlock(this.b, 0, this.c, 0);
            for (int i3 = 0; i3 < this.g - 2; ++i3) {
                byArray2[n3 + i3] = this.a(this.d[i3 + 2], i3);
            }
            System.arraycopy(this.d, 2, this.b, 0, this.g - 2);
            this.f += 2;
            return this.g - 2;
        }
        if (this.f >= this.g + 2) {
            System.arraycopy(byArray, n2, this.d, 0, this.g);
            byArray2[n3 + 0] = this.a(this.d[0], this.g - 2);
            byArray2[n3 + 1] = this.a(this.d[1], this.g - 1);
            System.arraycopy(this.d, 0, this.b, this.g - 2, 2);
            this.e.processBlock(this.b, 0, this.c, 0);
            for (int i4 = 0; i4 < this.g - 2; ++i4) {
                byArray2[n3 + i4 + 2] = this.a(this.d[i4 + 2], i4);
            }
            System.arraycopy(this.d, 2, this.b, 0, this.g - 2);
        }
        return this.g;
    }

    private int c(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        int n4;
        if (n2 + this.g > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + this.g > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        this.e.processBlock(this.b, 0, this.c, 0);
        for (n4 = 0; n4 < this.g; ++n4) {
            byArray2[n3 + n4] = this.a(byArray[n2 + n4], n4);
        }
        for (n4 = 0; n4 < this.g; ++n4) {
            this.b[n4] = byArray2[n3 + n4];
        }
        return this.g;
    }

    private int d(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        int n4;
        if (n2 + this.g > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + this.g > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        this.e.processBlock(this.b, 0, this.c, 0);
        for (n4 = 0; n4 < this.g; ++n4) {
            byArray2[n3 + n4] = this.a(byArray[n2 + n4], n4);
        }
        for (n4 = 0; n4 < this.g; ++n4) {
            this.b[n4] = byArray[n2 + n4];
        }
        return this.g;
    }
}

