/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.SkippingStreamCipher;
import com.enterprisedt.bouncycastle.crypto.StreamBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;

public class SICBlockCipher
extends StreamBlockCipher
implements SkippingStreamCipher {
    private final BlockCipher a;
    private final int b;
    private byte[] c;
    private byte[] d;
    private byte[] e;
    private int f;

    public SICBlockCipher(BlockCipher c2) {
        super(c2);
        this.a = c2;
        this.b = this.a.getBlockSize();
        this.c = new byte[this.b];
        this.d = new byte[this.b];
        this.e = new byte[this.b];
        this.f = 0;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (params instanceof ParametersWithIV) {
            int n2;
            ParametersWithIV parametersWithIV = (ParametersWithIV)params;
            this.c = Arrays.clone(parametersWithIV.getIV());
            if (this.b < this.c.length) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV no greater than: " + this.b + " bytes.");
            }
            int n3 = n2 = 8 > this.b / 2 ? this.b / 2 : 8;
            if (this.b - this.c.length > n2) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV of at least: " + (this.b - n2) + " bytes.");
            }
            if (parametersWithIV.getParameters() != null) {
                this.a.init(true, parametersWithIV.getParameters());
            }
        } else {
            throw new IllegalArgumentException("CTR/SIC mode requires ParametersWithIV");
        }
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getAlgorithmName() + "/SIC";
    }

    @Override
    public int getBlockSize() {
        return this.a.getBlockSize();
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.processBytes(in, inOff, this.b, out, outOff);
        return this.b;
    }

    @Override
    protected byte calculateByte(byte in) throws DataLengthException, IllegalStateException {
        if (this.f == 0) {
            this.a.processBlock(this.d, 0, this.e, 0);
            return (byte)(this.e[this.f++] ^ in);
        }
        byte by = (byte)(this.e[this.f++] ^ in);
        if (this.f == this.d.length) {
            this.f = 0;
            this.a(0);
            this.a();
        }
        return by;
    }

    private void a() {
        if (this.c.length < this.b) {
            for (int i2 = 0; i2 != this.c.length; ++i2) {
                if (this.d[i2] == this.c[i2]) continue;
                throw new IllegalStateException("Counter in CTR/SIC mode out of range.");
            }
        }
    }

    private void a(int n2) {
        int n3 = this.d.length - n2;
        while (--n3 >= 0) {
            int n4 = n3;
            this.d[n4] = (byte)(this.d[n4] + 1);
            if (this.d[n4] == 0) continue;
            break;
        }
    }

    private void b(int n2) {
        byte by = this.d[this.d.length - 1];
        int n3 = this.d.length - 1;
        this.d[n3] = (byte)(this.d[n3] + n2);
        if (by != 0 && this.d[this.d.length - 1] < by) {
            this.a(1);
        }
    }

    private void c(int n2) {
        int n3 = this.d.length - n2;
        while (--n3 >= 0) {
            int n4 = n3;
            this.d[n4] = (byte)(this.d[n4] - 1);
            if (this.d[n4] == -1) continue;
            return;
        }
    }

    private void a(long l2) {
        if (l2 >= 0L) {
            long l3 = (l2 + (long)this.f) / (long)this.b;
            long l4 = l3;
            if (l4 > 255L) {
                for (int i2 = 5; i2 >= 1; --i2) {
                    long l5 = 1L << 8 * i2;
                    while (l4 >= l5) {
                        this.a(i2);
                        l4 -= l5;
                    }
                }
            }
            this.b((int)l4);
            this.f = (int)(l2 + (long)this.f - (long)this.b * l3);
        } else {
            long l6 = (-l2 - (long)this.f) / (long)this.b;
            long l7 = l6;
            if (l7 > 255L) {
                for (int i3 = 5; i3 >= 1; --i3) {
                    long l8 = 1L << 8 * i3;
                    while (l7 > l8) {
                        this.c(i3);
                        l7 -= l8;
                    }
                }
            }
            for (long i4 = 0L; i4 != l7; ++i4) {
                this.c(0);
            }
            int n2 = (int)((long)this.f + l2 + (long)this.b * l6);
            if (n2 >= 0) {
                this.f = 0;
            } else {
                this.c(0);
                this.f = this.b + n2;
            }
        }
    }

    @Override
    public void reset() {
        Arrays.fill(this.d, (byte)0);
        System.arraycopy(this.c, 0, this.d, 0, this.c.length);
        this.a.reset();
        this.f = 0;
    }

    @Override
    public long skip(long numberOfBytes) {
        this.a(numberOfBytes);
        this.a();
        this.a.processBlock(this.d, 0, this.e, 0);
        return numberOfBytes;
    }

    @Override
    public long seekTo(long position) {
        this.reset();
        return this.skip(position);
    }

    @Override
    public long getPosition() {
        byte[] byArray = new byte[this.d.length];
        System.arraycopy(this.d, 0, byArray, 0, byArray.length);
        for (int i2 = byArray.length - 1; i2 >= 1; --i2) {
            int n2 = i2 < this.c.length ? (byArray[i2] & 0xFF) - (this.c[i2] & 0xFF) : byArray[i2] & 0xFF;
            if (n2 < 0) {
                int n3 = i2 - 1;
                byArray[n3] = (byte)(byArray[n3] - 1);
                n2 += 256;
            }
            byArray[i2] = (byte)n2;
        }
        return Pack.bigEndianToLong(byArray, byArray.length - 8) * (long)this.b + (long)this.f;
    }
}

