/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes.gcm;

import com.enterprisedt.bouncycastle.math.raw.Interleave;
import com.enterprisedt.bouncycastle.util.Pack;

public abstract class GCMUtil {
    public static byte[] oneAsBytes() {
        byte[] byArray = new byte[16];
        byArray[0] = -128;
        return byArray;
    }

    public static int[] oneAsInts() {
        int[] nArray = new int[4];
        nArray[0] = Integer.MIN_VALUE;
        return nArray;
    }

    public static long[] oneAsLongs() {
        long[] lArray = new long[2];
        lArray[0] = Long.MIN_VALUE;
        return lArray;
    }

    public static byte[] asBytes(int[] x2) {
        byte[] byArray = new byte[16];
        Pack.intToBigEndian(x2, byArray, 0);
        return byArray;
    }

    public static void asBytes(int[] x2, byte[] z2) {
        Pack.intToBigEndian(x2, z2, 0);
    }

    public static byte[] asBytes(long[] x2) {
        byte[] byArray = new byte[16];
        Pack.longToBigEndian(x2, byArray, 0);
        return byArray;
    }

    public static void asBytes(long[] x2, byte[] z2) {
        Pack.longToBigEndian(x2, z2, 0);
    }

    public static int[] asInts(byte[] x2) {
        int[] nArray = new int[4];
        Pack.bigEndianToInt(x2, 0, nArray);
        return nArray;
    }

    public static void asInts(byte[] x2, int[] z2) {
        Pack.bigEndianToInt(x2, 0, z2);
    }

    public static long[] asLongs(byte[] x2) {
        long[] lArray = new long[2];
        Pack.bigEndianToLong(x2, 0, lArray);
        return lArray;
    }

    public static void asLongs(byte[] x2, long[] z2) {
        Pack.bigEndianToLong(x2, 0, z2);
    }

    public static void copy(int[] x2, int[] z2) {
        z2[0] = x2[0];
        z2[1] = x2[1];
        z2[2] = x2[2];
        z2[3] = x2[3];
    }

    public static void copy(long[] x2, long[] z2) {
        z2[0] = x2[0];
        z2[1] = x2[1];
    }

    public static void divideP(long[] x2, long[] z2) {
        long l2 = x2[0];
        long l3 = x2[1];
        long l4 = l2 >> 63;
        z2[0] = (l2 ^= l4 & 0xE100000000000000L) << 1 | l3 >>> 63;
        z2[1] = l3 << 1 | -l4;
    }

    public static void multiply(byte[] x2, byte[] y2) {
        long[] lArray = GCMUtil.asLongs(x2);
        long[] lArray2 = GCMUtil.asLongs(y2);
        GCMUtil.multiply(lArray, lArray2);
        GCMUtil.asBytes(lArray, x2);
    }

    public static void multiply(int[] x2, int[] y2) {
        int n2 = y2[0];
        int n3 = y2[1];
        int n4 = y2[2];
        int n5 = y2[3];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n10 = x2[i2];
            for (int i3 = 0; i3 < 32; ++i3) {
                int n11 = n10 >> 31;
                n10 <<= 1;
                n6 ^= n2 & n11;
                n7 ^= n3 & n11;
                n8 ^= n4 & n11;
                n9 ^= n5 & n11;
                int n12 = n5 << 31 >> 8;
                n5 = n5 >>> 1 | n4 << 31;
                n4 = n4 >>> 1 | n3 << 31;
                n3 = n3 >>> 1 | n2 << 31;
                n2 = n2 >>> 1 ^ n12 & 0xE1000000;
            }
        }
        x2[0] = n6;
        x2[1] = n7;
        x2[2] = n8;
        x2[3] = n9;
    }

    public static void multiply(long[] x2, long[] y2) {
        long l2 = x2[0];
        long l3 = x2[1];
        long l4 = y2[0];
        long l5 = y2[1];
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        for (int i2 = 0; i2 < 64; ++i2) {
            long l9 = l2 >> 63;
            l2 <<= 1;
            l6 ^= l4 & l9;
            l7 ^= l5 & l9;
            long l10 = l3 >> 63;
            l3 <<= 1;
            l7 ^= l4 & l10;
            l8 ^= l5 & l10;
            long l11 = l5 << 63 >> 8;
            l5 = l5 >>> 1 | l4 << 63;
            l4 = l4 >>> 1 ^ l11 & 0xE100000000000000L;
        }
        x2[0] = l6 ^= l8 ^ l8 >>> 1 ^ l8 >>> 2 ^ l8 >>> 7;
        x2[1] = l7 ^= l8 << 63 ^ l8 << 62 ^ l8 << 57;
    }

    public static void multiplyP(int[] x2) {
        int n2 = x2[0];
        int n3 = x2[1];
        int n4 = x2[2];
        int n5 = x2[3];
        int n6 = n5 << 31 >> 31;
        x2[0] = n2 >>> 1 ^ n6 & 0xE1000000;
        x2[1] = n3 >>> 1 | n2 << 31;
        x2[2] = n4 >>> 1 | n3 << 31;
        x2[3] = n5 >>> 1 | n4 << 31;
    }

    public static void multiplyP(int[] x2, int[] z2) {
        int n2 = x2[0];
        int n3 = x2[1];
        int n4 = x2[2];
        int n5 = x2[3];
        int n6 = n5 << 31 >> 31;
        z2[0] = n2 >>> 1 ^ n6 & 0xE1000000;
        z2[1] = n3 >>> 1 | n2 << 31;
        z2[2] = n4 >>> 1 | n3 << 31;
        z2[3] = n5 >>> 1 | n4 << 31;
    }

    public static void multiplyP(long[] x2) {
        long l2 = x2[0];
        long l3 = x2[1];
        long l4 = l3 << 63 >> 63;
        x2[0] = l2 >>> 1 ^ l4 & 0xE100000000000000L;
        x2[1] = l3 >>> 1 | l2 << 63;
    }

    public static void multiplyP(long[] x2, long[] z2) {
        long l2 = x2[0];
        long l3 = x2[1];
        long l4 = l3 << 63 >> 63;
        z2[0] = l2 >>> 1 ^ l4 & 0xE100000000000000L;
        z2[1] = l3 >>> 1 | l2 << 63;
    }

    public static void multiplyP3(long[] x2, long[] z2) {
        long l2 = x2[0];
        long l3 = x2[1];
        long l4 = l3 << 61;
        z2[0] = l2 >>> 3 ^ l4 ^ l4 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        z2[1] = l3 >>> 3 | l2 << 61;
    }

    public static void multiplyP4(long[] x2, long[] z2) {
        long l2 = x2[0];
        long l3 = x2[1];
        long l4 = l3 << 60;
        z2[0] = l2 >>> 4 ^ l4 ^ l4 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        z2[1] = l3 >>> 4 | l2 << 60;
    }

    public static void multiplyP7(long[] x2, long[] z2) {
        long l2 = x2[0];
        long l3 = x2[1];
        long l4 = l3 << 57;
        z2[0] = l2 >>> 7 ^ l4 ^ l4 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        z2[1] = l3 >>> 7 | l2 << 57;
    }

    public static void multiplyP8(int[] x2) {
        int n2 = x2[0];
        int n3 = x2[1];
        int n4 = x2[2];
        int n5 = x2[3];
        int n6 = n5 << 24;
        x2[0] = n2 >>> 8 ^ n6 ^ n6 >>> 1 ^ n6 >>> 2 ^ n6 >>> 7;
        x2[1] = n3 >>> 8 | n2 << 24;
        x2[2] = n4 >>> 8 | n3 << 24;
        x2[3] = n5 >>> 8 | n4 << 24;
    }

    public static void multiplyP8(int[] x2, int[] y2) {
        int n2 = x2[0];
        int n3 = x2[1];
        int n4 = x2[2];
        int n5 = x2[3];
        int n6 = n5 << 24;
        y2[0] = n2 >>> 8 ^ n6 ^ n6 >>> 1 ^ n6 >>> 2 ^ n6 >>> 7;
        y2[1] = n3 >>> 8 | n2 << 24;
        y2[2] = n4 >>> 8 | n3 << 24;
        y2[3] = n5 >>> 8 | n4 << 24;
    }

    public static void multiplyP8(long[] x2) {
        long l2 = x2[0];
        long l3 = x2[1];
        long l4 = l3 << 56;
        x2[0] = l2 >>> 8 ^ l4 ^ l4 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        x2[1] = l3 >>> 8 | l2 << 56;
    }

    public static void multiplyP8(long[] x2, long[] y2) {
        long l2 = x2[0];
        long l3 = x2[1];
        long l4 = l3 << 56;
        y2[0] = l2 >>> 8 ^ l4 ^ l4 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        y2[1] = l3 >>> 8 | l2 << 56;
    }

    public static long[] pAsLongs() {
        long[] lArray = new long[2];
        lArray[0] = 0x4000000000000000L;
        return lArray;
    }

    public static void square(long[] x2, long[] z2) {
        long[] lArray = new long[4];
        Interleave.expand64To128Rev(x2[0], lArray, 0);
        Interleave.expand64To128Rev(x2[1], lArray, 2);
        long l2 = lArray[0];
        long l3 = lArray[1];
        long l4 = lArray[2];
        long l5 = lArray[3];
        l3 ^= l5 ^ l5 >>> 1 ^ l5 >>> 2 ^ l5 >>> 7;
        z2[0] = l2 ^= (l4 ^= l5 << 63 ^ l5 << 62 ^ l5 << 57) ^ l4 >>> 1 ^ l4 >>> 2 ^ l4 >>> 7;
        z2[1] = l3 ^= l4 << 63 ^ l4 << 62 ^ l4 << 57;
    }

    public static void xor(byte[] x2, byte[] y2) {
        int n2 = 0;
        do {
            int n3 = n2;
            x2[n3] = (byte)(x2[n3] ^ y2[n2]);
            int n4 = ++n2;
            x2[n4] = (byte)(x2[n4] ^ y2[n2]);
            int n5 = ++n2;
            x2[n5] = (byte)(x2[n5] ^ y2[n2]);
            int n6 = ++n2;
            x2[n6] = (byte)(x2[n6] ^ y2[n2]);
        } while (++n2 < 16);
    }

    public static void xor(byte[] x2, byte[] y2, int yOff) {
        int n2 = 0;
        do {
            int n3 = n2;
            x2[n3] = (byte)(x2[n3] ^ y2[yOff + n2]);
            int n4 = ++n2;
            x2[n4] = (byte)(x2[n4] ^ y2[yOff + n2]);
            int n5 = ++n2;
            x2[n5] = (byte)(x2[n5] ^ y2[yOff + n2]);
            int n6 = ++n2;
            x2[n6] = (byte)(x2[n6] ^ y2[yOff + n2]);
        } while (++n2 < 16);
    }

    public static void xor(byte[] x2, int xOff, byte[] y2, int yOff, byte[] z2, int zOff) {
        int n2 = 0;
        do {
            z2[zOff + n2] = (byte)(x2[xOff + n2] ^ y2[yOff + n2]);
            z2[zOff + ++n2] = (byte)(x2[xOff + n2] ^ y2[yOff + n2]);
            z2[zOff + ++n2] = (byte)(x2[xOff + n2] ^ y2[yOff + n2]);
            z2[zOff + ++n2] = (byte)(x2[xOff + n2] ^ y2[yOff + n2]);
        } while (++n2 < 16);
    }

    public static void xor(byte[] x2, byte[] y2, int yOff, int yLen) {
        while (--yLen >= 0) {
            int n2 = yLen;
            x2[n2] = (byte)(x2[n2] ^ y2[yOff + yLen]);
        }
    }

    public static void xor(byte[] x2, int xOff, byte[] y2, int yOff, int len) {
        while (--len >= 0) {
            int n2 = xOff + len;
            x2[n2] = (byte)(x2[n2] ^ y2[yOff + len]);
        }
    }

    public static void xor(byte[] x2, byte[] y2, byte[] z2) {
        int n2 = 0;
        do {
            z2[n2] = (byte)(x2[n2] ^ y2[n2]);
            z2[++n2] = (byte)(x2[n2] ^ y2[n2]);
            z2[++n2] = (byte)(x2[n2] ^ y2[n2]);
            z2[++n2] = (byte)(x2[n2] ^ y2[n2]);
        } while (++n2 < 16);
    }

    public static void xor(int[] x2, int[] y2) {
        x2[0] = x2[0] ^ y2[0];
        x2[1] = x2[1] ^ y2[1];
        x2[2] = x2[2] ^ y2[2];
        x2[3] = x2[3] ^ y2[3];
    }

    public static void xor(int[] x2, int[] y2, int[] z2) {
        z2[0] = x2[0] ^ y2[0];
        z2[1] = x2[1] ^ y2[1];
        z2[2] = x2[2] ^ y2[2];
        z2[3] = x2[3] ^ y2[3];
    }

    public static void xor(long[] x2, long[] y2) {
        x2[0] = x2[0] ^ y2[0];
        x2[1] = x2[1] ^ y2[1];
    }

    public static void xor(long[] x2, long[] y2, long[] z2) {
        z2[0] = x2[0] ^ y2[0];
        z2[1] = x2[1] ^ y2[1];
    }
}

