/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.modes.kgcm;

import com.enterprisedt.bouncycastle.math.raw.Interleave;

public class KGCMUtil_256 {
    public static final int SIZE = 4;

    public static void add(long[] x2, long[] y2, long[] z2) {
        z2[0] = x2[0] ^ y2[0];
        z2[1] = x2[1] ^ y2[1];
        z2[2] = x2[2] ^ y2[2];
        z2[3] = x2[3] ^ y2[3];
    }

    public static void copy(long[] x2, long[] z2) {
        z2[0] = x2[0];
        z2[1] = x2[1];
        z2[2] = x2[2];
        z2[3] = x2[3];
    }

    public static boolean equal(long[] x2, long[] y2) {
        long l2 = 0L;
        l2 |= x2[0] ^ y2[0];
        l2 |= x2[1] ^ y2[1];
        l2 |= x2[2] ^ y2[2];
        return (l2 |= x2[3] ^ y2[3]) == 0L;
    }

    public static void multiply(long[] x2, long[] y2, long[] z2) {
        long l2;
        long l3;
        long l4 = x2[0];
        long l5 = x2[1];
        long l6 = x2[2];
        long l7 = x2[3];
        long l8 = y2[0];
        long l9 = y2[1];
        long l10 = y2[2];
        long l11 = y2[3];
        long l12 = 0L;
        long l13 = 0L;
        long l14 = 0L;
        long l15 = 0L;
        long l16 = 0L;
        for (int i2 = 0; i2 < 64; ++i2) {
            long l17 = -(l4 & 1L);
            l4 >>>= 1;
            l12 ^= l8 & l17;
            l13 ^= l9 & l17;
            l14 ^= l10 & l17;
            l15 ^= l11 & l17;
            l3 = -(l5 & 1L);
            l5 >>>= 1;
            l13 ^= l8 & l3;
            l14 ^= l9 & l3;
            l15 ^= l10 & l3;
            l16 ^= l11 & l3;
            l2 = l11 >> 63;
            l11 = l11 << 1 | l10 >>> 63;
            l10 = l10 << 1 | l9 >>> 63;
            l9 = l9 << 1 | l8 >>> 63;
            l8 = l8 << 1 ^ l2 & 0x425L;
        }
        long l18 = l11;
        l11 = l10;
        l10 = l9;
        l9 = l8 ^ l18 >>> 62 ^ l18 >>> 59 ^ l18 >>> 54;
        l8 = l18 ^ l18 << 2 ^ l18 << 5 ^ l18 << 10;
        for (int i3 = 0; i3 < 64; ++i3) {
            l3 = -(l6 & 1L);
            l6 >>>= 1;
            l12 ^= l8 & l3;
            l13 ^= l9 & l3;
            l14 ^= l10 & l3;
            l15 ^= l11 & l3;
            l2 = -(l7 & 1L);
            l7 >>>= 1;
            l13 ^= l8 & l2;
            l14 ^= l9 & l2;
            l15 ^= l10 & l2;
            l16 ^= l11 & l2;
            long l19 = l11 >> 63;
            l11 = l11 << 1 | l10 >>> 63;
            l10 = l10 << 1 | l9 >>> 63;
            l9 = l9 << 1 | l8 >>> 63;
            l8 = l8 << 1 ^ l19 & 0x425L;
        }
        z2[0] = l12 ^= l16 ^ l16 << 2 ^ l16 << 5 ^ l16 << 10;
        z2[1] = l13 ^= l16 >>> 62 ^ l16 >>> 59 ^ l16 >>> 54;
        z2[2] = l14;
        z2[3] = l15;
    }

    public static void multiplyX(long[] x2, long[] z2) {
        long l2 = x2[0];
        long l3 = x2[1];
        long l4 = x2[2];
        long l5 = x2[3];
        long l6 = l5 >> 63;
        z2[0] = l2 << 1 ^ l6 & 0x425L;
        z2[1] = l3 << 1 | l2 >>> 63;
        z2[2] = l4 << 1 | l3 >>> 63;
        z2[3] = l5 << 1 | l4 >>> 63;
    }

    public static void multiplyX8(long[] x2, long[] z2) {
        long l2 = x2[0];
        long l3 = x2[1];
        long l4 = x2[2];
        long l5 = x2[3];
        long l6 = l5 >>> 56;
        z2[0] = l2 << 8 ^ l6 ^ l6 << 2 ^ l6 << 5 ^ l6 << 10;
        z2[1] = l3 << 8 | l2 >>> 56;
        z2[2] = l4 << 8 | l3 >>> 56;
        z2[3] = l5 << 8 | l4 >>> 56;
    }

    public static void one(long[] z2) {
        z2[0] = 1L;
        z2[1] = 0L;
        z2[2] = 0L;
        z2[3] = 0L;
    }

    public static void square(long[] x2, long[] z2) {
        int n2;
        long[] lArray = new long[8];
        for (n2 = 0; n2 < 4; ++n2) {
            Interleave.expand64To128(x2[n2], lArray, n2 << 1);
        }
        n2 = 8;
        while (--n2 >= 4) {
            long l2 = lArray[n2];
            int n3 = n2 - 4;
            lArray[n3] = lArray[n3] ^ (l2 ^ l2 << 2 ^ l2 << 5 ^ l2 << 10);
            int n4 = n2 - 4 + 1;
            lArray[n4] = lArray[n4] ^ (l2 >>> 62 ^ l2 >>> 59 ^ l2 >>> 54);
        }
        KGCMUtil_256.copy(lArray, z2);
    }

    public static void x(long[] z2) {
        z2[0] = 2L;
        z2[1] = 0L;
        z2[2] = 0L;
        z2[3] = 0L;
    }

    public static void zero(long[] z2) {
        z2[0] = 0L;
        z2[1] = 0L;
        z2[2] = 0L;
        z2[3] = 0L;
    }
}

