/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.paddings;

import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class ISO10126d2Padding
implements BlockCipherPadding {
    SecureRandom a;

    @Override
    public void init(SecureRandom random) throws IllegalArgumentException {
        this.a = random != null ? random : CryptoServicesRegistrar.getSecureRandom();
    }

    @Override
    public String getPaddingName() {
        return "ISO10126-2";
    }

    @Override
    public int addPadding(byte[] in, int inOff) {
        byte by = (byte)(in.length - inOff);
        while (inOff < in.length - 1) {
            in[inOff] = (byte)this.a.nextInt();
            ++inOff;
        }
        in[inOff] = by;
        return by;
    }

    @Override
    public int padCount(byte[] in) throws InvalidCipherTextException {
        int n2 = in[in.length - 1] & 0xFF;
        if (n2 > in.length) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return n2;
    }
}

