/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.paddings;

import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class ISO7816d4Padding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    @Override
    public String getPaddingName() {
        return "ISO7816-4";
    }

    @Override
    public int addPadding(byte[] in, int inOff) {
        int n2 = in.length - inOff;
        in[inOff] = -128;
        ++inOff;
        while (inOff < in.length) {
            in[inOff] = 0;
            ++inOff;
        }
        return n2;
    }

    @Override
    public int padCount(byte[] in) throws InvalidCipherTextException {
        int n2;
        for (n2 = in.length - 1; n2 > 0 && in[n2] == 0; --n2) {
        }
        if (in[n2] != -128) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return in.length - n2;
    }
}

