/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.paddings;

import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class PKCS7Padding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    @Override
    public String getPaddingName() {
        return "PKCS7";
    }

    @Override
    public int addPadding(byte[] in, int inOff) {
        byte by = (byte)(in.length - inOff);
        while (inOff < in.length) {
            in[inOff] = by;
            ++inOff;
        }
        return by;
    }

    @Override
    public int padCount(byte[] in) throws InvalidCipherTextException {
        int n2 = in[in.length - 1] & 0xFF;
        byte by = (byte)n2;
        boolean bl = n2 > in.length | n2 == 0;
        for (int i2 = 0; i2 < in.length; ++i2) {
            bl |= in.length - i2 <= n2 & in[i2] != by;
        }
        if (bl) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return n2;
    }
}

