/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.paddings;

import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class ZeroBytePadding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    @Override
    public String getPaddingName() {
        return "ZeroByte";
    }

    @Override
    public int addPadding(byte[] in, int inOff) {
        int n2 = in.length - inOff;
        while (inOff < in.length) {
            in[inOff] = 0;
            ++inOff;
        }
        return n2;
    }

    @Override
    public int padCount(byte[] in) throws InvalidCipherTextException {
        int n2;
        for (n2 = in.length; n2 > 0 && in[n2 - 1] == 0; --n2) {
        }
        return in.length - n2;
    }
}

