/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.params.DESParameters;

public class DESedeParameters
extends DESParameters {
    public static final int DES_EDE_KEY_LENGTH = 24;

    public DESedeParameters(byte[] key) {
        super(key);
        if (DESedeParameters.isWeakKey(key, 0, key.length)) {
            throw new IllegalArgumentException("attempt to create weak DESede key");
        }
    }

    public static boolean isWeakKey(byte[] key, int offset, int length) {
        for (int i2 = offset; i2 < length; i2 += 8) {
            if (!DESParameters.isWeakKey(key, i2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWeakKey(byte[] key, int offset) {
        return DESedeParameters.isWeakKey(key, offset, key.length - offset);
    }

    public static boolean isRealEDEKey(byte[] key, int offset) {
        return key.length == 16 ? DESedeParameters.isReal2Key(key, offset) : DESedeParameters.isReal3Key(key, offset);
    }

    public static boolean isReal2Key(byte[] key, int offset) {
        boolean bl = false;
        for (int i2 = offset; i2 != offset + 8; ++i2) {
            if (key[i2] == key[i2 + 8]) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean isReal3Key(byte[] key, int offset) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = offset; i2 != offset + 8; ++i2) {
            bl |= key[i2] != key[i2 + 8];
            bl2 |= key[i2] != key[i2 + 16];
            bl3 |= key[i2 + 8] != key[i2 + 16];
        }
        return bl && bl2 && bl3;
    }
}

