/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHMQVPrivateParameters
implements CipherParameters {
    private DHPrivateKeyParameters a;
    private DHPrivateKeyParameters b;
    private DHPublicKeyParameters c;

    public DHMQVPrivateParameters(DHPrivateKeyParameters staticPrivateKey, DHPrivateKeyParameters ephemeralPrivateKey) {
        this(staticPrivateKey, ephemeralPrivateKey, null);
    }

    public DHMQVPrivateParameters(DHPrivateKeyParameters staticPrivateKey, DHPrivateKeyParameters ephemeralPrivateKey, DHPublicKeyParameters ephemeralPublicKey) {
        if (staticPrivateKey == null) {
            throw new NullPointerException("staticPrivateKey cannot be null");
        }
        if (ephemeralPrivateKey == null) {
            throw new NullPointerException("ephemeralPrivateKey cannot be null");
        }
        DHParameters dHParameters = staticPrivateKey.getParameters();
        if (!dHParameters.equals(ephemeralPrivateKey.getParameters())) {
            throw new IllegalArgumentException("Static and ephemeral private keys have different domain parameters");
        }
        if (ephemeralPublicKey == null) {
            ephemeralPublicKey = new DHPublicKeyParameters(dHParameters.getG().multiply(ephemeralPrivateKey.getX()), dHParameters);
        } else if (!dHParameters.equals(ephemeralPublicKey.getParameters())) {
            throw new IllegalArgumentException("Ephemeral public key has different domain parameters");
        }
        this.a = staticPrivateKey;
        this.b = ephemeralPrivateKey;
        this.c = ephemeralPublicKey;
    }

    public DHPrivateKeyParameters getStaticPrivateKey() {
        return this.a;
    }

    public DHPrivateKeyParameters getEphemeralPrivateKey() {
        return this.b;
    }

    public DHPublicKeyParameters getEphemeralPublicKey() {
        return this.c;
    }
}

