/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.params.DSAValidationParameters;
import java.math.BigInteger;

public class DSAParameters
implements CipherParameters {
    private BigInteger a;
    private BigInteger b;
    private BigInteger c;
    private DSAValidationParameters d;

    public DSAParameters(BigInteger p2, BigInteger q2, BigInteger g2) {
        this.a = g2;
        this.c = p2;
        this.b = q2;
    }

    public DSAParameters(BigInteger p2, BigInteger q2, BigInteger g2, DSAValidationParameters params) {
        this.a = g2;
        this.c = p2;
        this.b = q2;
        this.d = params;
    }

    public BigInteger getP() {
        return this.c;
    }

    public BigInteger getQ() {
        return this.b;
    }

    public BigInteger getG() {
        return this.a;
    }

    public DSAValidationParameters getValidationParameters() {
        return this.d;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DSAParameters)) {
            return false;
        }
        DSAParameters dSAParameters = (DSAParameters)obj;
        return dSAParameters.getP().equals(this.c) && dSAParameters.getQ().equals(this.b) && dSAParameters.getG().equals(this.a);
    }

    public int hashCode() {
        return this.getP().hashCode() ^ this.getQ().hashCode() ^ this.getG().hashCode();
    }
}

