/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.params;

import com.enterprisedt.bouncycastle.crypto.DerivationParameters;
import com.enterprisedt.bouncycastle.util.Arrays;

public final class KDFDoublePipelineIterationParameters
implements DerivationParameters {
    private final byte[] a;
    private final boolean b;
    private final int c;
    private final byte[] d;

    private KDFDoublePipelineIterationParameters(byte[] ki, byte[] fixedInputData, int r2, boolean useCounter) {
        if (ki == null) {
            throw new IllegalArgumentException("A KDF requires Ki (a seed) as input");
        }
        this.a = Arrays.clone(ki);
        this.d = fixedInputData == null ? new byte[0] : Arrays.clone(fixedInputData);
        if (r2 != 8 && r2 != 16 && r2 != 24 && r2 != 32) {
            throw new IllegalArgumentException("Length of counter should be 8, 16, 24 or 32");
        }
        this.c = r2;
        this.b = useCounter;
    }

    public static KDFDoublePipelineIterationParameters createWithCounter(byte[] ki, byte[] fixedInputData, int r2) {
        return new KDFDoublePipelineIterationParameters(ki, fixedInputData, r2, true);
    }

    public static KDFDoublePipelineIterationParameters createWithoutCounter(byte[] ki, byte[] fixedInputData) {
        return new KDFDoublePipelineIterationParameters(ki, fixedInputData, 32, false);
    }

    public byte[] getKI() {
        return this.a;
    }

    public boolean useCounter() {
        return this.b;
    }

    public int getR() {
        return this.c;
    }

    public byte[] getFixedInputData() {
        return Arrays.clone(this.d);
    }
}

