/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.prng;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.prng.BasicEntropySourceProvider;
import com.enterprisedt.bouncycastle.crypto.prng.EntropySourceProvider;
import com.enterprisedt.bouncycastle.crypto.prng.X931RNG;
import com.enterprisedt.bouncycastle.crypto.prng.X931SecureRandom;
import com.enterprisedt.bouncycastle.util.Pack;
import java.security.SecureRandom;

public class X931SecureRandomBuilder {
    private SecureRandom a;
    private EntropySourceProvider b;
    private byte[] c;

    public X931SecureRandomBuilder() {
        this(CryptoServicesRegistrar.getSecureRandom(), false);
    }

    public X931SecureRandomBuilder(SecureRandom entropySource, boolean predictionResistant) {
        this.a = entropySource;
        this.b = new BasicEntropySourceProvider(this.a, predictionResistant);
    }

    public X931SecureRandomBuilder(EntropySourceProvider entropySourceProvider) {
        this.a = null;
        this.b = entropySourceProvider;
    }

    public X931SecureRandomBuilder setDateTimeVector(byte[] dateTimeVector) {
        this.c = dateTimeVector;
        return this;
    }

    public X931SecureRandom build(BlockCipher engine, KeyParameter key, boolean predictionResistant) {
        if (this.c == null) {
            this.c = new byte[engine.getBlockSize()];
            Pack.longToBigEndian(System.currentTimeMillis(), this.c, 0);
        }
        engine.init(true, key);
        return new X931SecureRandom(this.a, new X931RNG(engine, this.c, this.b.get(engine.getBlockSize() * 8)), predictionResistant);
    }
}

