/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.prng.drbg;

import com.enterprisedt.bouncycastle.math.ec.ECPoint;

public class DualECPoints {
    private final ECPoint a;
    private final ECPoint b;
    private final int c;
    private final int d;

    public DualECPoints(int securityStrength, ECPoint p2, ECPoint q2, int cofactor) {
        if (!p2.getCurve().equals(q2.getCurve())) {
            throw new IllegalArgumentException("points need to be on the same curve");
        }
        this.c = securityStrength;
        this.a = p2;
        this.b = q2;
        this.d = cofactor;
    }

    public int getSeedLen() {
        return this.a.getCurve().getFieldSize();
    }

    public int getMaxOutlen() {
        return (this.a.getCurve().getFieldSize() - (13 + DualECPoints.a(this.d))) / 8 * 8;
    }

    public ECPoint getP() {
        return this.a;
    }

    public ECPoint getQ() {
        return this.b;
    }

    public int getSecurityStrength() {
        return this.c;
    }

    public int getCofactor() {
        return this.d;
    }

    private static int a(int n2) {
        int n3 = 0;
        while ((n2 >>= 1) != 0) {
            ++n3;
        }
        return n3;
    }
}

