/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.DSA;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.Signer;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import java.io.IOException;
import java.math.BigInteger;

public class DSADigestSigner
implements Signer {
    private final Digest a;
    private final DSA b;
    private boolean c;

    public DSADigestSigner(DSA signer, Digest digest) {
        this.a = digest;
        this.b = signer;
    }

    @Override
    public void init(boolean forSigning, CipherParameters parameters) {
        this.c = forSigning;
        AsymmetricKeyParameter asymmetricKeyParameter = parameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)parameters).getParameters() : (AsymmetricKeyParameter)parameters;
        if (forSigning && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Signing Requires Private Key.");
        }
        if (!forSigning && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("Verification Requires Public Key.");
        }
        this.reset();
        this.b.init(forSigning, parameters);
    }

    @Override
    public void update(byte input) {
        this.a.update(input);
    }

    @Override
    public void update(byte[] input, int inOff, int length) {
        this.a.update(input, inOff, length);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.c) {
            throw new IllegalStateException("DSADigestSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray, 0);
        BigInteger[] bigIntegerArray = this.b.generateSignature(byArray);
        try {
            return this.a(bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to encode signature");
        }
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        if (this.c) {
            throw new IllegalStateException("DSADigestSigner not initialised for verification");
        }
        byte[] byArray = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray, 0);
        try {
            BigInteger[] bigIntegerArray = this.a(signature);
            return this.b.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    private byte[] a(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(bigInteger));
        aSN1EncodableVector.add(new ASN1Integer(bigInteger2));
        return new DERSequence(aSN1EncodableVector).getEncoded("DER");
    }

    private BigInteger[] a(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        return new BigInteger[]{((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue(), ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue()};
    }
}

