/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.crypto.signers;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DSA;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.signers.DSAKCalculator;
import com.enterprisedt.bouncycastle.crypto.signers.RandomDSAKCalculator;
import com.enterprisedt.bouncycastle.math.ec.ECAlgorithms;
import com.enterprisedt.bouncycastle.math.ec.ECConstants;
import com.enterprisedt.bouncycastle.math.ec.ECCurve;
import com.enterprisedt.bouncycastle.math.ec.ECFieldElement;
import com.enterprisedt.bouncycastle.math.ec.ECMultiplier;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECDSASigner
implements DSA,
ECConstants {
    private final DSAKCalculator a;
    private ECKeyParameters b;
    private SecureRandom c;

    public ECDSASigner() {
        this.a = new RandomDSAKCalculator();
    }

    public ECDSASigner(DSAKCalculator kCalculator) {
        this.a = kCalculator;
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        SecureRandom secureRandom = null;
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
                this.b = (ECPrivateKeyParameters)parametersWithRandom.getParameters();
                secureRandom = parametersWithRandom.getRandom();
            } else {
                this.b = (ECPrivateKeyParameters)param;
            }
        } else {
            this.b = (ECPublicKeyParameters)param;
        }
        this.c = this.initSecureRandom(forSigning && !this.a.isDeterministic(), secureRandom);
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        ECPoint eCPoint;
        BigInteger bigInteger3;
        ECDomainParameters eCDomainParameters = this.b.getParameters();
        BigInteger bigInteger4 = eCDomainParameters.getN();
        BigInteger bigInteger5 = this.calculateE(bigInteger4, message);
        BigInteger bigInteger6 = ((ECPrivateKeyParameters)this.b).getD();
        if (this.a.isDeterministic()) {
            this.a.init(bigInteger4, bigInteger6, message);
        } else {
            this.a.init(bigInteger4, this.c);
        }
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        do {
            bigInteger2 = this.a.nextK();
        } while ((bigInteger3 = (eCPoint = eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger2).normalize()).getAffineXCoord().toBigInteger().mod(bigInteger4)).equals(ZERO) || (bigInteger = bigInteger2.modInverse(bigInteger4).multiply(bigInteger5.add(bigInteger6.multiply(bigInteger3))).mod(bigInteger4)).equals(ZERO));
        return new BigInteger[]{bigInteger3, bigInteger};
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r2, BigInteger s2) {
        ECFieldElement eCFieldElement;
        BigInteger bigInteger;
        ECPoint eCPoint;
        ECDomainParameters eCDomainParameters = this.b.getParameters();
        BigInteger bigInteger2 = eCDomainParameters.getN();
        BigInteger bigInteger3 = this.calculateE(bigInteger2, message);
        if (r2.compareTo(ONE) < 0 || r2.compareTo(bigInteger2) >= 0) {
            return false;
        }
        if (s2.compareTo(ONE) < 0 || s2.compareTo(bigInteger2) >= 0) {
            return false;
        }
        BigInteger bigInteger4 = s2.modInverse(bigInteger2);
        BigInteger bigInteger5 = bigInteger3.multiply(bigInteger4).mod(bigInteger2);
        BigInteger bigInteger6 = r2.multiply(bigInteger4).mod(bigInteger2);
        ECPoint eCPoint2 = eCDomainParameters.getG();
        ECPoint eCPoint3 = ECAlgorithms.sumOfTwoMultiplies(eCPoint2, bigInteger5, eCPoint = ((ECPublicKeyParameters)this.b).getQ(), bigInteger6);
        if (eCPoint3.isInfinity()) {
            return false;
        }
        ECCurve eCCurve = eCPoint3.getCurve();
        if (eCCurve != null && (bigInteger = eCCurve.getCofactor()) != null && bigInteger.compareTo(EIGHT) <= 0 && (eCFieldElement = this.getDenominator(eCCurve.getCoordinateSystem(), eCPoint3)) != null && !eCFieldElement.isZero()) {
            ECFieldElement eCFieldElement2 = eCPoint3.getXCoord();
            while (eCCurve.isValidFieldElement(r2)) {
                ECFieldElement eCFieldElement3 = eCCurve.fromBigInteger(r2).multiply(eCFieldElement);
                if (eCFieldElement3.equals(eCFieldElement2)) {
                    return true;
                }
                r2 = r2.add(bigInteger2);
            }
            return false;
        }
        bigInteger = eCPoint3.normalize().getAffineXCoord().toBigInteger().mod(bigInteger2);
        return bigInteger.equals(r2);
    }

    protected BigInteger calculateE(BigInteger n2, byte[] message) {
        int n3 = n2.bitLength();
        int n4 = message.length * 8;
        BigInteger bigInteger = new BigInteger(1, message);
        if (n3 < n4) {
            bigInteger = bigInteger.shiftRight(n4 - n3);
        }
        return bigInteger;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    protected ECFieldElement getDenominator(int coordinateSystem, ECPoint p2) {
        switch (coordinateSystem) {
            case 1: 
            case 6: 
            case 7: {
                return p2.getZCoord(0);
            }
            case 2: 
            case 3: 
            case 4: {
                return p2.getZCoord(0).square();
            }
        }
        return null;
    }

    protected SecureRandom initSecureRandom(boolean needed, SecureRandom provided) {
        return !needed ? null : (provided != null ? provided : CryptoServicesRegistrar.getSecureRandom());
    }
}

